/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ls.services.textdocument;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.eclipse.acceleo.aql.completion.AcceleoCompletor;
import org.eclipse.acceleo.aql.ls.AcceleoLanguageServer;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerPositionUtils;
import org.eclipse.acceleo.aql.ls.common.AcceleoLanguageServerServicesUtils;
import org.eclipse.acceleo.aql.ls.services.exceptions.LanguageServerProtocolException;
import org.eclipse.acceleo.aql.ls.services.textdocument.AcceleoTextDocument;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoProject;
import org.eclipse.acceleo.aql.ls.services.workspace.AcceleoWorkspace;
import org.eclipse.acceleo.aql.outline.AcceleoOutliner;
import org.eclipse.acceleo.aql.validation.IAcceleoValidationResult;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DeclarationParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PrepareRenameDefaultBehavior;
import org.eclipse.lsp4j.PrepareRenameParams;
import org.eclipse.lsp4j.PrepareRenameResult;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WillSaveTextDocumentParams;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.CompletableFutures;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.Either3;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.TextDocumentService;

public class AcceleoTextDocumentService
implements TextDocumentService,
LanguageClientAware {
    private final Map<URI, AcceleoTextDocument> openedDocumentsIndex = new HashMap<URI, AcceleoTextDocument>();
    private final AcceleoLanguageServer server;
    private LanguageClient languageClient;

    public AcceleoTextDocumentService(AcceleoLanguageServer acceleoLanguageServer) {
        this.server = Objects.requireNonNull(acceleoLanguageServer);
    }

    public void connect(LanguageClient newLanguageClient) {
        this.languageClient = newLanguageClient;
        this.openedDocumentsIndex.clear();
    }

    public void disconnect() {
        this.languageClient = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void didOpen(DidOpenTextDocumentParams params) {
        AcceleoWorkspace workspace;
        AcceleoWorkspace acceleoWorkspace = workspace = this.server.getWorkspace();
        synchronized (acceleoWorkspace) {
            URI openedDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
            AcceleoTextDocument openedAcceleoTextDocument = this.server.getWorkspace().getDocument(openedDocumentUri);
            if (openedAcceleoTextDocument == null) {
                AcceleoProject project = workspace.getProject(openedDocumentUri);
                IQueryWorkspaceQualifiedNameResolver resolver = workspace.getResolver(project);
                URI binaryURI = resolver.getBinaryURI(openedDocumentUri);
                workspace.addResource(project, binaryURI);
                openedAcceleoTextDocument = workspace.getDocument(openedDocumentUri);
                if (openedAcceleoTextDocument != null) {
                    openedAcceleoTextDocument.validateAndPublishResults();
                }
            }
            if (openedAcceleoTextDocument == null) {
                throw new IllegalStateException("Could not find the Acceleo Text Document at URI " + String.valueOf(openedDocumentUri));
            }
            this.open(openedDocumentUri, openedAcceleoTextDocument);
            openedAcceleoTextDocument.open(params.getTextDocument().getText());
        }
    }

    public void open(URI openedDocumentUri, AcceleoTextDocument acceleoTextDocument) {
        this.openedDocumentsIndex.put(openedDocumentUri, acceleoTextDocument);
    }

    public void close(URI closedDocumentUri) {
        this.openedDocumentsIndex.remove(closedDocumentUri);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        URI changedDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument changedAcceleoTextDocument = this.getAcceleoTextDocument(changedDocumentUri, true, true);
        List textDocumentContentchangeEvents = params.getContentChanges();
        changedAcceleoTextDocument.applyChanges(textDocumentContentchangeEvents);
    }

    public void didClose(DidCloseTextDocumentParams params) {
        URI closedDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument closedAcceleoTextDocument = this.getAcceleoTextDocument(closedDocumentUri, false, true);
        if (closedAcceleoTextDocument == null) {
            throw new IllegalStateException("Could not find the Acceleo Text Document at URI " + String.valueOf(closedDocumentUri));
        }
        closedAcceleoTextDocument.close();
        this.close(closedDocumentUri);
    }

    public void didSave(DidSaveTextDocumentParams params) {
    }

    public void publishValidationResults(AcceleoTextDocument acceleoTextDocument) {
        if (this.languageClient != null) {
            IAcceleoValidationResult validationResults = acceleoTextDocument.getAcceleoValidationResults();
            List<Diagnostic> diagnosticsToPublish = AcceleoLanguageServerServicesUtils.transform(validationResults, acceleoTextDocument.getContents());
            URI sourceURI = acceleoTextDocument.getProject().getResolver().getSourceURI(acceleoTextDocument.getModuleQualifiedName());
            if (sourceURI != null) {
                this.languageClient.publishDiagnostics(new PublishDiagnosticsParams(sourceURI.toASCIIString(), diagnosticsToPublish));
            }
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, true);
        Position position = params.getPosition();
        return AcceleoTextDocumentService.completion(acceleoTextDocument, position);
    }

    private static CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            AcceleoCompletor acceleoCompletor = new AcceleoCompletor(System.lineSeparator());
            String source = acceleoTextDocument.getContents();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, source);
            List completionProposals = acceleoCompletor.getProposals(acceleoTextDocument.getQueryEnvironment(), acceleoTextDocument.getFileNameWithoutExtension(), source, atIndex);
            canceler.checkCanceled();
            CompletionList res = new CompletionList();
            List<CompletionItem> completionItems = AcceleoLanguageServerServicesUtils.transform(completionProposals);
            res.getItems().addAll(completionItems);
            res.setIsIncomplete(true);
            canceler.checkCanceled();
            return Either.forRight((Object)res);
        });
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            return unresolved;
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(DeclarationParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, true);
        Position position = params.getPosition();
        return this.declaration(acceleoTextDocument, position);
    }

    private CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> declaration(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, acceleoTextDocument.getContents());
            canceler.checkCanceled();
            return Either.forRight(acceleoTextDocument.getDeclarationLocations(atIndex, true));
        });
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, true);
        Position position = params.getPosition();
        return this.definition(acceleoTextDocument, position);
    }

    private CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, acceleoTextDocument.getContents());
            canceler.checkCanceled();
            return Either.forRight(acceleoTextDocument.getDefinitionLocations(atIndex));
        });
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, true);
        return AcceleoTextDocumentService.documentSymbol(acceleoTextDocument);
    }

    private static CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(AcceleoTextDocument acceleoTextDocument) {
        return CompletableFutures.computeAsync(canceler -> {
            List documentSymbols;
            canceler.checkCanceled();
            if (acceleoTextDocument.getAcceleoValidationResults() != null) {
                AcceleoOutliner acceleoOutliner = new AcceleoOutliner();
                List acceleoSymbols = acceleoOutliner.getAllDeclaredSymbols(acceleoTextDocument.getAcceleoValidationResults());
                canceler.checkCanceled();
                documentSymbols = acceleoSymbols.stream().map(acceleoSymbol -> AcceleoLanguageServerServicesUtils.transform(acceleoSymbol, acceleoTextDocument.getContents())).map(Either::forRight).collect(Collectors.toList());
            } else {
                documentSymbols = Collections.emptyList();
            }
            canceler.checkCanceled();
            return documentSymbols;
        });
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, true);
        Position position = params.getPosition();
        return this.references(acceleoTextDocument, position);
    }

    private CompletableFuture<List<? extends Location>> references(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, acceleoTextDocument.getContents());
            List<Location> locations = acceleoTextDocument.getReferencesLocations(atIndex, true);
            canceler.checkCanceled();
            return locations;
        });
    }

    public CompletableFuture<List<TextEdit>> willSaveWaitUntil(WillSaveTextDocumentParams params) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            return Collections.emptyList();
        });
    }

    public CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(PrepareRenameParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, true);
        Position position = params.getPosition();
        return this.prepareRename(acceleoTextDocument, position);
    }

    private CompletableFuture<Either3<Range, PrepareRenameResult, PrepareRenameDefaultBehavior>> prepareRename(AcceleoTextDocument acceleoTextDocument, Position position) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, acceleoTextDocument.getContents());
            PrepareRenameResult prepareRenameResult = acceleoTextDocument.getPrepareRenameResult(atIndex);
            canceler.checkCanceled();
            return Either3.forSecond((Object)prepareRenameResult);
        });
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, true);
        Position position = params.getPosition();
        return this.rename(acceleoTextDocument, position, params.getNewName());
    }

    private CompletableFuture<WorkspaceEdit> rename(AcceleoTextDocument acceleoTextDocument, Position position, String newName) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(position, acceleoTextDocument.getContents());
            Map<String, List<TextEdit>> changes = acceleoTextDocument.getRenames(atIndex, newName);
            canceler.checkCanceled();
            return new WorkspaceEdit(changes);
        });
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        URI textDocumentUri = AcceleoLanguageServerServicesUtils.toUri(params.getTextDocument().getUri());
        AcceleoTextDocument acceleoTextDocument = this.getAcceleoTextDocument(textDocumentUri, false, false);
        Range position = params.getRange();
        CodeActionContext context = params.getContext();
        return this.codeAction(acceleoTextDocument, position, context);
    }

    protected AcceleoTextDocument getAcceleoTextDocument(URI textDocumentUri, boolean fromWorkspace, boolean checkOpened) {
        AcceleoTextDocument openedDocument = this.openedDocumentsIndex.get(textDocumentUri);
        if (checkOpened && openedDocument == null) {
            throw new LanguageServerProtocolException("Received a notification for document \"" + String.valueOf(textDocumentUri) + "\" but it has not previously been opened. This should never happen.");
        }
        AcceleoTextDocument res = fromWorkspace || openedDocument == null ? this.server.getWorkspace().getDocument(textDocumentUri) : openedDocument;
        return res;
    }

    private CompletableFuture<List<Either<Command, CodeAction>>> codeAction(AcceleoTextDocument acceleoTextDocument, Range range, CodeActionContext context) {
        return CompletableFutures.computeAsync(canceler -> {
            canceler.checkCanceled();
            int atStartIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(range.getStart(), acceleoTextDocument.getContents());
            int atEndIndex = AcceleoLanguageServerPositionUtils.getCorrespondingCharacterIndex(range.getEnd(), acceleoTextDocument.getContents());
            List<Either<Command, CodeAction>> codeActions = acceleoTextDocument.getCodeActions(atStartIndex, atEndIndex, context);
            canceler.checkCanceled();
            return codeActions;
        });
    }
}

