/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.delegates;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.acceleo.query.parser.AstResult;
import org.eclipse.acceleo.query.runtime.AcceleoQueryEvaluationException;
import org.eclipse.acceleo.query.runtime.EvaluationResult;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IQueryEvaluationEngine;
import org.eclipse.acceleo.query.runtime.QueryEvaluation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;

public class AQLInvocationDelegate
implements EOperation.Internal.InvocationDelegate {
    private final IQueryEvaluationEngine engine;
    private final AstResult astResult;
    private final List<String> parameterNames;

    public AQLInvocationDelegate(IQueryEnvironment queryEnvironment, AstResult astResult, List<String> parameterNames) {
        this.engine = QueryEvaluation.newEngine(queryEnvironment);
        this.astResult = astResult;
        this.parameterNames = parameterNames;
    }

    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        EvaluationResult evaluationResult;
        if (arguments.size() != this.parameterNames.size()) {
            throw new IllegalArgumentException("number of arguments mismatch " + arguments.size() + " instead of " + this.parameterNames.size());
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("self", target);
        int index = 0;
        while (index < this.parameterNames.size()) {
            variables.put(this.parameterNames.get(index), arguments.get(index));
            ++index;
        }
        try {
            evaluationResult = this.engine.eval(this.astResult, variables);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
        if (evaluationResult.getDiagnostic().getSeverity() == 4) {
            throw new InvocationTargetException(new AcceleoQueryEvaluationException(evaluationResult.getDiagnostic().getMessage()));
        }
        return evaluationResult.getResult();
    }
}

