/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.launcher;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.acceleo.Module;
import org.eclipse.acceleo.OpenModeKind;
import org.eclipse.acceleo.aql.AcceleoUtil;
import org.eclipse.acceleo.aql.evaluation.AcceleoEvaluator;
import org.eclipse.acceleo.aql.evaluation.GenerationResult;
import org.eclipse.acceleo.aql.evaluation.strategy.DefaultGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.aql.evaluation.strategy.IWriterFactory;
import org.eclipse.acceleo.aql.evaluation.writer.IAcceleoWriter;
import org.eclipse.acceleo.aql.ide.evaluation.strategy.AcceleoWorkspaceWriterFactory;
import org.eclipse.acceleo.aql.launcher.AcceleoLauncherPlugin;
import org.eclipse.acceleo.aql.parser.AcceleoParser;
import org.eclipse.acceleo.aql.parser.ModuleLoader;
import org.eclipse.acceleo.query.AQLUtils;
import org.eclipse.acceleo.query.ast.ASTNode;
import org.eclipse.acceleo.query.ide.QueryPlugin;
import org.eclipse.acceleo.query.ide.runtime.impl.namespace.OSGiQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.osgi.framework.Bundle;

public class AcceleoLauncher
implements IApplication {
    private static final Integer APPLICATION_ERROR = -1;
    @Option(name="-models", usage="Specifies the input models for this generation.", metaVar="INPUT", handler=StringArrayOptionHandler.class, required=true)
    private String[] models = new String[0];
    @Option(name="-bundle", usage="The identifier of the bundle containing the main module of the generation to start.", metaVar="BUNDLE", handler=StringOptionHandler.class, required=true)
    private String bundleIdentifier;
    @Option(name="-module", usage="Specifies the module which main template will be executed.", metaVar="MODULE", handler=StringOptionHandler.class, required=true)
    private String moduleQualifiedName;
    @Option(name="-target", usage="Specifies the destination for the generation.", metaVar="TARGET", handler=StringOptionHandler.class, required=true)
    private String target;
    @Option(name="-data", usage="Specify the folder which will keep the workspace.", metaVar="FOLDER")
    private File dataFolder;
    @Option(name="-consoleLog", usage="Log messages in the console.")
    private boolean consoleLog;
    @Option(name="-log", usage="Specifies the module which main template will be executed.", metaVar="LOG", handler=StringOptionHandler.class, required=false)
    private String log;
    private List<URI> modelURIs;
    private Bundle bundle;
    private URI targetURI;
    private URI logURI;

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        return new AcceleoLauncher().doMain(args);
    }

    public Object doMain(String[] args) {
        CmdLineParser parser = new CmdLineParser((Object)this);
        Integer applicationResult = IApplication.EXIT_OK;
        try {
            parser.parseArgument(args);
            this.validateArguments(parser);
            GenerationResult result = this.launchGeneration();
            if (result.getDiagnostic().getSeverity() > 1) {
                PrintStream stream;
                switch (result.getDiagnostic().getSeverity()) {
                    case 2: {
                        stream = System.out;
                        stream.println("WARNING");
                        break;
                    }
                    default: {
                        stream = System.err;
                        stream.println("ERROR");
                        applicationResult = APPLICATION_ERROR;
                    }
                }
                if (this.consoleLog) {
                    this.printDiagnostic(stream, result.getDiagnostic(), "");
                    this.printSummary(System.out, result);
                }
            }
            Set generatedFiles = result.getGeneratedFiles();
            System.out.println("Generated " + generatedFiles.size() + " in " + this.target);
            if (result.getGeneratedFiles().size() <= 10) {
                for (URI generated : result.getGeneratedFiles()) {
                    System.out.println(generated);
                }
            }
        }
        catch (CmdLineException e) {
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            AcceleoLauncherPlugin.INSTANCE.log((Object)e);
            applicationResult = APPLICATION_ERROR;
        }
        return applicationResult;
    }

    private void validateArguments(CmdLineParser parser) throws CmdLineException {
        if (this.models.length == 0 || this.models[0].length() == 0) {
            throw new CmdLineException(parser, "The input model path cannot be empty.");
        }
        if (this.bundleIdentifier.length() == 0) {
            throw new CmdLineException(parser, "The main module's containing bundle identifier cannot be empty.");
        }
        if (this.moduleQualifiedName.length() == 0) {
            throw new CmdLineException(parser, "The main module's qualified name cannot be empty.");
        }
        if (this.target.length() == 0) {
            throw new CmdLineException(parser, "The target folder path cannot be empty.");
        }
        this.modelURIs = this.convertToURIs(parser, this.models);
        this.bundle = Platform.getBundle((String)this.bundleIdentifier);
        if (this.bundle == null || this.bundle.getState() == 1) {
            throw new CmdLineException(parser, "The Bundle " + this.bundleIdentifier + " must be available in the target platform.");
        }
        try {
            this.targetURI = URI.createURI((String)this.target);
        }
        catch (IllegalArgumentException e) {
            throw new CmdLineException(parser, (Throwable)e);
        }
        try {
            this.logURI = AcceleoUtil.getlogURI((URI)this.targetURI, (String)this.log);
        }
        catch (IllegalArgumentException e) {
            throw new CmdLineException(parser, (Throwable)e);
        }
    }

    private List<URI> convertToURIs(CmdLineParser parser, String ... paths) throws CmdLineException {
        ArrayList<URI> uris = new ArrayList<URI>();
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            URI pathURI = null;
            try {
                pathURI = URI.createURI((String)path, (boolean)true);
            }
            catch (IllegalArgumentException e) {
                throw new CmdLineException(parser, (Throwable)e);
            }
            if (pathURI != null && !pathURI.hasAbsolutePath()) {
                pathURI = URI.createFileURI((String)path);
            }
            if (pathURI != null) {
                uris.add(pathURI);
            }
            ++n2;
        }
        return uris;
    }

    private GenerationResult launchGeneration() {
        OSGiQualifiedNameResolver resolver = new OSGiQualifiedNameResolver(this.bundle, "::");
        LinkedHashMap options = new LinkedHashMap();
        ArrayList exceptions = new ArrayList();
        ResourceSet resourceSetForModels = AQLUtils.createResourceSetForModels(exceptions, (Object)resolver, (ResourceSet)new ResourceSetImpl(), options);
        for (URI modelURI : this.modelURIs) {
            resourceSetForModels.getResource(modelURI, true);
        }
        IQualifiedNameQueryEnvironment queryEnvironment = AcceleoUtil.newAcceleoQueryEnvironment(options, (IQualifiedNameResolver)resolver, (ResourceSet)resourceSetForModels, (boolean)false);
        try {
            String newLine = options.getOrDefault("newLine", System.lineSeparator());
            AcceleoEvaluator evaluator = new AcceleoEvaluator(queryEnvironment.getLookupEngine(), newLine);
            resolver.addLoader((ILoader)new ModuleLoader(new AcceleoParser(), evaluator));
            resolver.addLoader(QueryPlugin.getPlugin().createJavaLoader("::", false));
            Object resolved = resolver.resolve(this.moduleQualifiedName);
            Module mainModule = resolved instanceof Module ? (Module)resolved : null;
            this.evaluate(evaluator, queryEnvironment, mainModule, resourceSetForModels, this.targetURI, this.logURI);
            GenerationResult generationResult = evaluator.getGenerationResult();
            return generationResult;
        }
        finally {
            AQLUtils.cleanResourceSetForModels((Object)resolver, (ResourceSet)resourceSetForModels);
            AcceleoUtil.cleanServices((IReadOnlyQueryEnvironment)queryEnvironment, (ResourceSet)resourceSetForModels);
        }
    }

    private void evaluate(AcceleoEvaluator evaluator, IQualifiedNameQueryEnvironment queryEnvironment, Module mainModule, ResourceSet modelResourceSet, URI targetURI, URI logURI) {
        DefaultGenerationStrategy strategy = new DefaultGenerationStrategy(modelResourceSet.getURIConverter(), (IWriterFactory)new AcceleoWorkspaceWriterFactory()){

            public IAcceleoWriter createWriterFor(URI uri, OpenModeKind openMode, Charset charset, String lineDelimiter) throws IOException {
                System.out.println(uri);
                return super.createWriterFor(uri, openMode, charset, lineDelimiter);
            }
        };
        AcceleoUtil.generate((AcceleoEvaluator)evaluator, (IQualifiedNameQueryEnvironment)queryEnvironment, (Module)mainModule, (ResourceSet)modelResourceSet, (IAcceleoGenerationStrategy)strategy, (URI)targetURI, (URI)logURI);
    }

    private void printDiagnostic(PrintStream stream, Diagnostic diagnostic, String indentation) {
        Object nextIndentation = indentation;
        if (diagnostic.getMessage() != null) {
            stream.print(indentation);
            switch (diagnostic.getSeverity()) {
                case 1: {
                    stream.print("INFO ");
                    break;
                }
                case 2: {
                    stream.print("WARNING ");
                    break;
                }
                case 4: {
                    stream.print("ERROR ");
                }
            }
            if (!diagnostic.getData().isEmpty() && diagnostic.getData().get(0) instanceof ASTNode) {
                stream.print(AcceleoUtil.getLocation((ASTNode)((ASTNode)diagnostic.getData().get(0))));
            }
            stream.println(": " + diagnostic.getMessage());
            nextIndentation = (String)nextIndentation + "\t";
        }
        for (Diagnostic child : diagnostic.getChildren()) {
            this.printDiagnostic(stream, child, (String)nextIndentation);
        }
    }

    private void printSummary(PrintStream stream, GenerationResult result) {
        int nbErrors = 0;
        int nbWarnings = 0;
        int nbInfos = 0;
        for (Diagnostic diagnostic : result.getDiagnostic().getChildren()) {
            switch (diagnostic.getSeverity()) {
                case 4: {
                    ++nbErrors;
                    break;
                }
                case 2: {
                    ++nbWarnings;
                    break;
                }
                case 1: {
                    ++nbInfos;
                    break;
                }
            }
        }
        stream.print("Files: " + result.getGeneratedFiles().size());
        stream.print(", Lost Files: " + result.getLostFiles().size());
        stream.print(", Errors: " + nbErrors);
        stream.print(", Warnings: " + nbWarnings);
        stream.print(", Infos: " + nbInfos);
        stream.println(".");
    }

    public void stop() {
    }
}

