/*******************************************************************************
 *  Copyright (c) 2019, 2023 Obeo. 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v2.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v20.html
 *   
 *   Contributors:
 *       Obeo - initial API and implementation
 *  
 *******************************************************************************/
package org.eclipse.acceleo.query.ide.ui.services.configurator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.eclipse.acceleo.query.ide.ui.services.SWTPromptServices;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.services.configurator.IServicesConfigurator;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.resource.ResourceSet;

/**
 * {@link SWTPromptServices} {@link IServicesConfigurator}.
 * 
 * @author <a href="mailto:yvan.lussaud@obeo.fr">Yvan Lussaud</a>
 */
public class SWTPromptServicesConfigurator implements IServicesConfigurator {

	/**
	 * The mapping of instances.
	 */
	private final Map<Object, SWTPromptServices> services = new HashMap<>();

	@Override
	public List<String> getOptions() {
		return Collections.emptyList();
	}

	@Override
	public Map<String, String> getInitializedOptions(Map<String, String> options) {
		return Collections.emptyMap();
	}

	@Override
	public Map<String, List<Diagnostic>> validate(IReadOnlyQueryEnvironment queryEnvironment,
			Map<String, String> options) {
		return Collections.emptyMap();
	}

	@Override
	public Set<IService<?>> getServices(IReadOnlyQueryEnvironment queryEnvironment,
			ResourceSet resourceSetForModels, Map<String, String> options, boolean forWorkspace) {
		SWTPromptServices serviceInstance = new SWTPromptServices(queryEnvironment, resourceSetForModels);
		services.put(queryEnvironment, serviceInstance);

		return ServiceUtils.getServices(queryEnvironment, serviceInstance, forWorkspace);
	}

	@Override
	public void cleanServices(IReadOnlyQueryEnvironment queryEnvironment, ResourceSet resourceSetForModels) {
		final SWTPromptServices serviceInstance = services.remove(queryEnvironment);
		if (serviceInstance != null) {
			serviceInstance.dispose();
		}
	}

}
