/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.namespace.workspace;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.namespace.ILoader;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameLookupEngine;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.runtime.namespace.ISourceLocation;
import org.eclipse.acceleo.query.runtime.namespace.workspace.IQueryWorkspaceQualifiedNameResolver;

public abstract class QueryWorkspaceQualifiedNameResolver
implements IQueryWorkspaceQualifiedNameResolver {
    private final IQualifiedNameResolver resolver;

    public QueryWorkspaceQualifiedNameResolver(IQualifiedNameResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public IQualifiedNameResolver getLocalProjectResolver() {
        return this.resolver;
    }

    protected abstract Set<IQueryWorkspaceQualifiedNameResolver> getDependencies();

    @Override
    public IQueryWorkspaceQualifiedNameResolver getDeclarationResolver(String qualifiedName) {
        IQueryWorkspaceQualifiedNameResolver res = null;
        if (this.resolver.getResolvedQualifiedNames().contains(qualifiedName)) {
            res = this;
        } else {
            for (IQueryWorkspaceQualifiedNameResolver resolver : this.getDependencies()) {
                if (!resolver.getLocalProjectResolver().getResolvedQualifiedNames().contains(qualifiedName)) continue;
                res = resolver;
                break;
            }
        }
        return res;
    }

    @Override
    public String getQualifiedName(URI uri) {
        return this.delegateToFirstResolver(r -> r.getQualifiedName(uri));
    }

    @Override
    public URI getURI(String qualifiedName) {
        return this.delegateToFirstResolver(r -> r.getURI(qualifiedName));
    }

    @Override
    public URI getSourceURI(String qualifiedName) {
        return this.delegateToFirstResolver(r -> r.getSourceURI(qualifiedName));
    }

    @Override
    public ISourceLocation getSourceLocation(IService<?> service) {
        return this.delegateToFirstResolver(r -> r.getSourceLocation(service));
    }

    @Override
    public ISourceLocation getSourceLocation(String qualifiedName) {
        return this.delegateToFirstResolver(r -> r.getSourceLocation(qualifiedName));
    }

    @Override
    public void clear(Set<String> qualifiedNames) {
        this.resolver.clear(qualifiedNames);
    }

    @Override
    public Object resolve(String qualifiedName) {
        return this.delegateToFirstResolver(r -> r.resolve(qualifiedName));
    }

    @Override
    public void register(String qualifiedName, Object object) {
        this.resolver.register(qualifiedName, object);
    }

    @Override
    public String getQualifiedName(Object object) {
        return this.delegateToFirstResolver(r -> r.getQualifiedName(object));
    }

    @Override
    public URI getURI(Object object) {
        return this.delegateToFirstResolver(r -> r.getURI(object));
    }

    @Override
    public Set<IService<?>> getServices(IQualifiedNameLookupEngine lookupEngine, Object object, String contextQualifiedName) {
        return this.resolver.getServices(lookupEngine, object, contextQualifiedName);
    }

    @Override
    public String getContextQualifiedName(IService<?> service) {
        return this.resolver.getContextQualifiedName(service);
    }

    @Override
    public void cleanContextQualifiedName(String qualifiedName) {
        this.resolver.cleanContextQualifiedName(qualifiedName);
    }

    @Override
    public String getExtend(String qualifiedName) {
        return this.resolver.getExtend(qualifiedName);
    }

    @Override
    public List<String> getImports(String qualifiedName) {
        return this.resolver.getImports(qualifiedName);
    }

    @Override
    public Set<String> getDependOn(String qualifiedName) {
        return this.resolver.getDependOn(qualifiedName);
    }

    @Override
    public Set<String> getAvailableQualifiedNames() {
        return this.delegateToFirstResolver(r -> r.getAvailableQualifiedNames());
    }

    @Override
    public Set<String> getResolvedQualifiedNames() {
        return this.resolver.getResolvedQualifiedNames();
    }

    @Override
    public InputStream getInputStream(String resourceName) {
        return this.delegateToFirstResolver(r -> r.getInputStream(resourceName));
    }

    @Override
    public Class<?> getClass(String qualifiedName) {
        return this.delegateToFirstResolver(r -> r.getClass(qualifiedName));
    }

    @Override
    public void addLoader(ILoader loader) {
        this.resolver.addLoader(loader);
    }

    @Override
    public void removeLoader(ILoader loader) {
        this.resolver.removeLoader(loader);
    }

    @Override
    public void clearLoaders() {
        this.resolver.clearLoaders();
    }

    @Override
    public URI getBinaryURI(URI sourceURI) {
        return this.delegateToFirstResolver(r -> r.getBinaryURI(sourceURI));
    }

    private <A, R> R delegateToFirstResolver(Function<IQualifiedNameResolver, R> function) {
        R res = function.apply(this.resolver);
        if (res == null) {
            for (IQueryWorkspaceQualifiedNameResolver resolver : this.getDependencies()) {
                res = function.apply(resolver.getLocalProjectResolver());
                if (res != null) break;
            }
        }
        return res;
    }
}

