/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime;

import java.util.Properties;
import java.util.Set;
import org.eclipse.acceleo.query.runtime.CrossReferenceProvider;
import org.eclipse.acceleo.query.runtime.IQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IReadOnlyQueryEnvironment;
import org.eclipse.acceleo.query.runtime.IRootEObjectProvider;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.ServiceUtils;
import org.eclipse.acceleo.query.runtime.impl.QueryEnvironment;
import org.eclipse.acceleo.query.runtime.impl.namespace.QualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameQueryEnvironment;
import org.eclipse.acceleo.query.runtime.namespace.IQualifiedNameResolver;
import org.eclipse.acceleo.query.services.AnyServices;
import org.eclipse.acceleo.query.services.BooleanServices;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.acceleo.query.services.ComparableServices;
import org.eclipse.acceleo.query.services.EObjectServices;
import org.eclipse.acceleo.query.services.NumberServices;
import org.eclipse.acceleo.query.services.PromptServices;
import org.eclipse.acceleo.query.services.PropertiesServices;
import org.eclipse.acceleo.query.services.ResourceServices;
import org.eclipse.acceleo.query.services.StringServices;
import org.eclipse.acceleo.query.services.XPathServices;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;

public final class Query {
    private Query() {
    }

    public static IQueryEnvironment newEnvironmentWithDefaultServices(CrossReferenceProvider xRefProvider) {
        return Query.newEnvironmentWithDefaultServices(xRefProvider, null);
    }

    public static IQueryEnvironment newEnvironmentWithDefaultServices(CrossReferenceProvider xRefProvider, IRootEObjectProvider rootProvider) {
        IQueryEnvironment env = Query.newEnvironment();
        Query.configureEnvironment(env, xRefProvider, rootProvider);
        return env;
    }

    public static void configureEnvironment(IQueryEnvironment env, CrossReferenceProvider xRefProvider, IRootEObjectProvider rootProvider) {
        Query.configureEnvironment(env, xRefProvider, rootProvider, false);
    }

    public static void configureEnvironment(IQueryEnvironment env, CrossReferenceProvider xRefProvider, IRootEObjectProvider rootProvider, boolean forWorkspace) {
        Query.configureEnvironment(env, xRefProvider, rootProvider, new Properties(), forWorkspace);
    }

    public static void configureEnvironment(IQueryEnvironment env, CrossReferenceProvider xRefProvider, IRootEObjectProvider rootProvider, Properties properties) {
        Query.configureEnvironment(env, xRefProvider, rootProvider, properties, false);
    }

    public static void configureEnvironment(IQueryEnvironment env, CrossReferenceProvider xRefProvider, IRootEObjectProvider rootProvider, Properties properties, boolean forWorkspace) {
        Set<IService<?>> services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, new AnyServices(env), forWorkspace);
        ServiceUtils.registerServices(env, services);
        env.registerEPackage((EPackage)EcorePackage.eINSTANCE);
        env.registerCustomClassMapping((EClassifier)EcorePackage.eINSTANCE.getEStringToStringMapEntry(), EStringToStringMapEntryImpl.class);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, new EObjectServices(env, xRefProvider, rootProvider), forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, new XPathServices(env), forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, ComparableServices.class, forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, NumberServices.class, forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, StringServices.class, forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, BooleanServices.class, forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, CollectionServices.class, forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, ResourceServices.class, forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, PromptServices.class, forWorkspace);
        ServiceUtils.registerServices(env, services);
        services = ServiceUtils.getServices((IReadOnlyQueryEnvironment)env, new PropertiesServices(properties));
        ServiceUtils.registerServices(env, services);
    }

    public static IQueryEnvironment newEnvironment() {
        return new QueryEnvironment();
    }

    public static IQualifiedNameQueryEnvironment newQualifiedNameEnvironmentWithDefaultServices(IQualifiedNameResolver resolver, CrossReferenceProvider xRefProvider) {
        return Query.newQualifiedNameEnvironmentWithDefaultServices(resolver, xRefProvider, null, new Properties(), false);
    }

    public static IQualifiedNameQueryEnvironment newQualifiedNameEnvironmentWithDefaultServices(IQualifiedNameResolver resolver, CrossReferenceProvider xRefProvider, IRootEObjectProvider rootProvider, Properties properties, boolean forWorkspace) {
        IQualifiedNameQueryEnvironment env = Query.newQualifiedNameEnvironment(resolver);
        Query.configureEnvironment(env, xRefProvider, rootProvider, properties, forWorkspace);
        return env;
    }

    public static IQualifiedNameQueryEnvironment newQualifiedNameEnvironment(IQualifiedNameResolver resolver) {
        QualifiedNameQueryEnvironment res = new QualifiedNameQueryEnvironment(resolver);
        resolver.setLookupEngine(res.getLookupEngine());
        return res;
    }
}

