/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.acceleo.query.ast.Binding;
import org.eclipse.acceleo.query.ast.BooleanLiteral;
import org.eclipse.acceleo.query.ast.Call;
import org.eclipse.acceleo.query.ast.CallType;
import org.eclipse.acceleo.query.ast.ClassTypeLiteral;
import org.eclipse.acceleo.query.ast.CollectionTypeLiteral;
import org.eclipse.acceleo.query.ast.Conditional;
import org.eclipse.acceleo.query.ast.EClassifierTypeLiteral;
import org.eclipse.acceleo.query.ast.EnumLiteral;
import org.eclipse.acceleo.query.ast.Expression;
import org.eclipse.acceleo.query.ast.IntegerLiteral;
import org.eclipse.acceleo.query.ast.Lambda;
import org.eclipse.acceleo.query.ast.Let;
import org.eclipse.acceleo.query.ast.NullLiteral;
import org.eclipse.acceleo.query.ast.RealLiteral;
import org.eclipse.acceleo.query.ast.SequenceInExtensionLiteral;
import org.eclipse.acceleo.query.ast.SetInExtensionLiteral;
import org.eclipse.acceleo.query.ast.StringLiteral;
import org.eclipse.acceleo.query.ast.TypeLiteral;
import org.eclipse.acceleo.query.ast.TypeSetLiteral;
import org.eclipse.acceleo.query.ast.VarRef;
import org.eclipse.acceleo.query.ast.VariableDeclaration;
import org.eclipse.acceleo.query.ast.util.AstSwitch;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.emf.ecore.EObject;

public class AstSerializer
extends AstSwitch<Object> {
    public static final String STRING_TYPE = "String";
    public static final String INTEGER_TYPE = "Integer";
    public static final String REAL_TYPE = "Real";
    public static final String BOOLEAN_TYPE = "Boolean";
    private static final Object DUMMY = new Object();
    private static final String SPACE = " ";
    public static final String ECORE_SEPARATOR = "::";
    private static final Map<String, Integer> OPERATOR_PRECEDENCE = AstSerializer.initOperatorPrecedence();
    private StringBuilder builder;

    public String serialize(Expression expression) {
        this.builder = new StringBuilder();
        this.doSwitch(expression);
        return this.builder.toString();
    }

    private static Map<String, Integer> initOperatorPrecedence() {
        HashMap<String, Integer> res = new HashMap<String, Integer>();
        int precedence = 0;
        res.put("not", precedence);
        res.put("unaryMin", ++precedence);
        res.put("mult", ++precedence);
        res.put("divOp", precedence);
        res.put("add", ++precedence);
        res.put("sub", precedence);
        res.put("lessThanEqual", ++precedence);
        res.put("greaterThanEqual", precedence);
        res.put("differs", precedence);
        res.put("equals", precedence);
        res.put("lessThan", precedence);
        res.put("greaterThan", precedence);
        res.put("and", ++precedence);
        res.put("or", ++precedence);
        res.put("xor", ++precedence);
        res.put("implies", ++precedence);
        return res;
    }

    @Override
    public Object caseBinding(Binding binding) {
        String bindingName = AstBuilder.protectWithUnderscore(binding.getName());
        this.builder.append(bindingName);
        if (binding.getType() != null) {
            this.builder.append(SPACE).append(':').append(SPACE);
            this.doSwitch(binding.getType());
        }
        this.builder.append(SPACE).append('=').append(SPACE);
        this.doSwitch(binding.getValue());
        return DUMMY;
    }

    @Override
    public Object caseBooleanLiteral(BooleanLiteral booleanLiteral) {
        this.builder.append(booleanLiteral.isValue());
        return DUMMY;
    }

    @Override
    public Object caseCall(Call call) {
        if ("aqlFeatureAccess".equals(call.getServiceName())) {
            this.aqlFeatureAccessCall(call);
        } else if ("not".equals(call.getServiceName())) {
            this.notCall(call);
        } else if ("differs".equals(call.getServiceName())) {
            this.differsCall(call);
        } else if ("equals".equals(call.getServiceName())) {
            this.equalsCall(call);
        } else if ("greaterThanEqual".equals(call.getServiceName())) {
            this.greaterThanEqualCall(call);
        } else if ("greaterThan".equals(call.getServiceName())) {
            this.greaterThanCall(call);
        } else if ("lessThanEqual".equals(call.getServiceName())) {
            this.lessThanEqualCall(call);
        } else if ("lessThan".equals(call.getServiceName())) {
            this.lessThanCall(call);
        } else if ("divOp".equals(call.getServiceName())) {
            this.divOpCall(call);
        } else if ("mult".equals(call.getServiceName())) {
            this.multCall(call);
        } else if ("sub".equals(call.getServiceName())) {
            this.subCall(call);
        } else if ("add".equals(call.getServiceName())) {
            this.addCall(call);
        } else if ("unaryMin".equals(call.getServiceName())) {
            this.unaryMinCall(call);
        } else if ("and".equals(call.getServiceName())) {
            this.andCall(call);
        } else if ("or".equals(call.getServiceName())) {
            this.orCall(call);
        } else if ("xor".equals(call.getServiceName())) {
            this.xorCall(call);
        } else if ("implies".equals(call.getServiceName())) {
            this.impliesCall(call);
        } else {
            this.call(call);
        }
        return DUMMY;
    }

    private void notCall(Call call) {
        this.builder.append("not");
        this.builder.append(SPACE);
        if (!call.getArguments().isEmpty()) {
            this.doSwitch((EObject)call.getArguments().get(0));
        }
    }

    private void differsCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("<>");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void equalsCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("=");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void greaterThanEqualCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append(">=");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void greaterThanCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append(">");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void lessThanEqualCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("<=");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void lessThanCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("<");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void divOpCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("/");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void multCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("*");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void subCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("-");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void addCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("+");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void unaryMinCall(Call call) {
        ArrayList<Expression> arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments());
        this.builder.append("-");
        if (!arguments.isEmpty()) {
            Expression operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
    }

    private void andCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("and");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void orCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("or");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void xorCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append(')');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("xor");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private void impliesCall(Call call) {
        Expression operand;
        ArrayList<Expression> arguments;
        boolean needParenthesis = this.needParenthesis(call);
        if (needParenthesis) {
            this.builder.append('(');
        }
        if (!(arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments())).isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        this.builder.append(SPACE);
        this.builder.append("implies");
        this.builder.append(SPACE);
        if (!arguments.isEmpty()) {
            operand = (Expression)arguments.remove(0);
            this.doSwitch(operand);
        }
        if (needParenthesis) {
            this.builder.append(')');
        }
    }

    private boolean needParenthesis(Call call) {
        Call parent;
        int delta;
        Integer parentPrecedence;
        Integer precedence = OPERATOR_PRECEDENCE.get(call.getServiceName());
        if (call.eContainer() instanceof Call) {
            parentPrecedence = OPERATOR_PRECEDENCE.get(((Call)call.eContainer()).getServiceName());
            if (parentPrecedence == null && ((Call)call.eContainer()).getArguments().get(0) == call) {
                parentPrecedence = -1;
            }
        } else {
            parentPrecedence = null;
        }
        boolean res = precedence == null || parentPrecedence == null ? false : ((delta = precedence - parentPrecedence) > 0 ? true : (delta == 0 ? ("sub".equals((parent = (Call)call.eContainer()).getServiceName()) || "divOp".equals(parent.getServiceName())) && parent.getArguments().size() == 2 && parent.getArguments().get(1) == call : false));
        return res;
    }

    private void aqlFeatureAccessCall(Call call) {
        ArrayList<Expression> arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments());
        Expression receiver = (Expression)arguments.remove(0);
        this.doSwitch(receiver);
        this.builder.append('.');
        if (!arguments.isEmpty()) {
            StringLiteral featureNameLiteral = (StringLiteral)arguments.get(0);
            String featureName = AstBuilder.protectWithUnderscore(featureNameLiteral.getValue());
            this.builder.append(featureName);
        }
    }

    private void call(Call call) {
        String serviceName;
        ArrayList<Expression> arguments = new ArrayList<Expression>((Collection<Expression>)call.getArguments());
        Expression receiver = (Expression)arguments.remove(0);
        this.doSwitch(receiver);
        if (call.getType() == CallType.COLLECTIONCALL) {
            this.builder.append("->");
            serviceName = !arguments.isEmpty() && arguments.get(0) instanceof Lambda ? call.getServiceName() : AstBuilder.protectWithUnderscore(call.getServiceName());
        } else {
            this.builder.append('.');
            serviceName = AstBuilder.protectWithUnderscore(call.getServiceName());
        }
        if (call.isSuperCall()) {
            this.builder.append("super:");
        }
        this.builder.append(serviceName);
        this.builder.append('(');
        if (!arguments.isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (Expression argument : arguments) {
                    this.doSwitch(argument);
                    this.builder.append(',').append(' ');
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(')');
    }

    @Override
    public Object caseCollectionTypeLiteral(CollectionTypeLiteral collectionTypeLiteral) {
        if (collectionTypeLiteral.getValue() == List.class) {
            this.builder.append("Sequence(");
        } else if (collectionTypeLiteral.getValue() == Set.class) {
            this.builder.append("OrderedSet(");
        } else {
            this.builder.append("***invalid type of collection ***(");
        }
        this.doSwitch(collectionTypeLiteral.getElementType());
        this.builder.append(")");
        return DUMMY;
    }

    @Override
    public Object caseConditional(Conditional conditional) {
        this.builder.append("if ");
        this.doSwitch(conditional.getPredicate());
        this.builder.append(" then ");
        this.doSwitch(conditional.getTrueBranch());
        this.builder.append(" else ");
        this.doSwitch(conditional.getFalseBranch());
        this.builder.append(" endif");
        return DUMMY;
    }

    @Override
    public Object caseEnumLiteral(EnumLiteral enumLiteral) {
        this.builder.append(AstBuilder.protectWithUnderscore(enumLiteral.getEPackageName()));
        this.builder.append(ECORE_SEPARATOR);
        this.builder.append(AstBuilder.protectWithUnderscore(enumLiteral.getEEnumName()));
        this.builder.append(ECORE_SEPARATOR);
        this.builder.append(AstBuilder.protectWithUnderscore(enumLiteral.getEEnumLiteralName()));
        return DUMMY;
    }

    @Override
    public Object caseIntegerLiteral(IntegerLiteral object) {
        this.builder.append(object.getValue());
        return DUMMY;
    }

    @Override
    public Object caseLambda(Lambda lambda) {
        this.doSwitch((EObject)lambda.getParameters().get(0));
        this.builder.append(" | ");
        this.doSwitch(lambda.getExpression());
        return DUMMY;
    }

    @Override
    public Object caseLet(Let let) {
        this.builder.append("let ");
        if (!let.getBindings().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (Binding binding : let.getBindings()) {
                    this.doSwitch(binding);
                    this.builder.append(',').append(' ');
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append(" in ");
        this.doSwitch(let.getBody());
        return super.caseLet(let);
    }

    @Override
    public Object caseNullLiteral(NullLiteral nullLiteral) {
        this.builder.append("null");
        return DUMMY;
    }

    @Override
    public Object caseSequenceInExtensionLiteral(SequenceInExtensionLiteral sequenceInExtensionLiteral) {
        this.builder.append("Sequence{");
        if (!sequenceInExtensionLiteral.getValues().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (Expression value : sequenceInExtensionLiteral.getValues()) {
                    this.doSwitch(value);
                    this.builder.append(',').append(' ');
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append('}');
        return DUMMY;
    }

    @Override
    public Object caseRealLiteral(RealLiteral realLiteral) {
        this.builder.append(realLiteral.getValue());
        return DUMMY;
    }

    @Override
    public Object caseSetInExtensionLiteral(SetInExtensionLiteral setInExtensionLiteral) {
        this.builder.append("OrderedSet{");
        if (!setInExtensionLiteral.getValues().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (Expression value : setInExtensionLiteral.getValues()) {
                    this.doSwitch(value);
                    this.builder.append(',').append(' ');
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 2));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append('}');
        return DUMMY;
    }

    @Override
    public Object caseStringLiteral(StringLiteral stringLiteral) {
        this.builder.append('\'');
        this.builder.append(this.escape(stringLiteral.getValue()));
        this.builder.append('\'');
        return DUMMY;
    }

    private String escape(String value) {
        StringBuilder res = new StringBuilder();
        int i = 0;
        while (i < value.length()) {
            char currentChar = value.charAt(i);
            switch (currentChar) {
                case '\b': {
                    res.append("\\b");
                    break;
                }
                case '\t': {
                    res.append("\\t");
                    break;
                }
                case '\n': {
                    res.append("\\n");
                    break;
                }
                case '\f': {
                    res.append("\\f");
                    break;
                }
                case '\r': {
                    res.append("\\r");
                    break;
                }
                case '\\': {
                    res.append("\\\\");
                    break;
                }
                case '\'': {
                    res.append("\\'");
                    break;
                }
                default: {
                    res.append(currentChar);
                }
            }
            ++i;
        }
        return res.toString();
    }

    @Override
    public Object caseTypeSetLiteral(TypeSetLiteral typeSetLiteral) {
        this.builder.append('{');
        if (!typeSetLiteral.getTypes().isEmpty()) {
            StringBuilder previousBuilder = this.builder;
            try {
                this.builder = new StringBuilder();
                for (TypeLiteral type : typeSetLiteral.getTypes()) {
                    this.doSwitch(type);
                    this.builder.append(" | ");
                }
                previousBuilder.append(this.builder.substring(0, this.builder.length() - 3));
            }
            finally {
                this.builder = previousBuilder;
            }
        }
        this.builder.append('}');
        return DUMMY;
    }

    @Override
    public Object caseClassTypeLiteral(ClassTypeLiteral classTypeLiteral) {
        if (classTypeLiteral.getValue() == Double.class) {
            this.builder.append(REAL_TYPE);
        } else {
            this.builder.append(classTypeLiteral.getValue().getSimpleName());
        }
        return DUMMY;
    }

    @Override
    public Object caseEClassifierTypeLiteral(EClassifierTypeLiteral object) {
        this.builder.append(AstBuilder.protectWithUnderscore(object.getEPackageName()));
        this.builder.append(ECORE_SEPARATOR);
        this.builder.append(AstBuilder.protectWithUnderscore(object.getEClassifierName()));
        return DUMMY;
    }

    @Override
    public Object caseVariableDeclaration(VariableDeclaration variableDeclaration) {
        String variableName = AstBuilder.protectWithUnderscore(variableDeclaration.getName());
        this.builder.append(variableName);
        if (variableDeclaration.getType() != null) {
            this.builder.append(SPACE).append(':').append(SPACE);
            this.doSwitch(variableDeclaration.getType());
        }
        return DUMMY;
    }

    @Override
    public Object caseVarRef(VarRef varRef) {
        String variableName = AstBuilder.protectWithUnderscore(varRef.getVariableName());
        this.builder.append(variableName);
        return DUMMY;
    }
}

