/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.supports.AutoClosingPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPairSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterActionAndIndent;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.RichEditSupport;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;

public class LanguageConfigurationRegistry {
    private static final String EXTENSION_LANGUAGE_CONFIGURATIONS = "languageConfigurations";
    private static final String LANGUAGE_CONFIGURATION_ELT = "languageConfiguration";
    private static LanguageConfigurationRegistry INSTANCE;
    private final Map<String, RichEditSupport> supports = new HashMap<String, RichEditSupport>();

    public static LanguageConfigurationRegistry getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = LanguageConfigurationRegistry.createInstance();
        return INSTANCE;
    }

    private static synchronized LanguageConfigurationRegistry createInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        LanguageConfigurationRegistry manager = new LanguageConfigurationRegistry();
        manager.load();
        return manager;
    }

    private void load() {
        this.loadFromExtensionPoints();
    }

    private void loadFromExtensionPoints() {
        IConfigurationElement[] cf;
        IConfigurationElement[] iConfigurationElementArray = cf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.languageconfiguration", EXTENSION_LANGUAGE_CONFIGURATIONS);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String name = ce.getName();
            if (LANGUAGE_CONFIGURATION_ELT.equals(name)) {
                LanguageConfigurationDefinition delegate = new LanguageConfigurationDefinition(ce);
                this.register(delegate, delegate.getContentTypeId());
            }
            ++n2;
        }
    }

    private CharacterPairSupport _getCharacterPairSupport(String contentTypeId) {
        RichEditSupport value = this.getRichEditSupport(contentTypeId);
        if (value == null) {
            return null;
        }
        return value.getCharacterPair();
    }

    public void register(LanguageConfigurationDefinition configuration, String contentTypeId) {
        RichEditSupport current = new RichEditSupport(contentTypeId, null, configuration);
        this.supports.put(contentTypeId, current);
    }

    private RichEditSupport getRichEditSupport(String contentTypeId) {
        return this.supports.get(contentTypeId);
    }

    public List<AutoClosingPair> getAutoClosingPairs(String contentTypeId) {
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentTypeId);
        if (characterPairSupport == null) {
            return Collections.emptyList();
        }
        return characterPairSupport.getAutoClosingPairs();
    }

    public boolean shouldAutoClosePair(String character, String contentTypeId) {
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentTypeId);
        if (characterPairSupport == null) {
            return false;
        }
        return characterPairSupport.shouldAutoClosePair(character);
    }

    public EnterActionAndIndent getEnterAction(IDocument document, int offset, String contentTypeId) {
        EnterAction enterResult;
        String indentation;
        block10: {
            indentation = TextUtils.getIndentationAtPosition(document, offset);
            OnEnterSupport onEnterSupport = this._getOnEnterSupport(contentTypeId);
            if (onEnterSupport == null) {
                return null;
            }
            try {
                IRegion lineInfo = document.getLineInformationOfOffset(offset);
                String beforeEnterText = document.get(lineInfo.getOffset(), offset - lineInfo.getOffset());
                String afterEnterText = null;
                afterEnterText = document.get(offset, lineInfo.getLength() - (offset - lineInfo.getOffset()));
                String oneLineAboveText = "";
                enterResult = null;
                try {
                    enterResult = onEnterSupport.onEnter(oneLineAboveText, beforeEnterText, afterEnterText);
                }
                catch (Exception exception) {}
                if (enterResult != null) break block10;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if (enterResult.getAppendText() == null) {
            if (enterResult.getIndentAction() == EnterAction.IndentAction.Indent || enterResult.getIndentAction() == EnterAction.IndentAction.IndentOutdent) {
                enterResult.setAppendText("\t");
            } else {
                enterResult.setAppendText("");
            }
        }
        if (enterResult.getRemoveText() != null) {
            indentation = indentation.substring(0, indentation.length() - enterResult.getRemoveText());
        }
        return new EnterActionAndIndent(enterResult, indentation);
    }

    private OnEnterSupport _getOnEnterSupport(String contentTypeId) {
        RichEditSupport value = this.getRichEditSupport(contentTypeId);
        if (value == null) {
            return null;
        }
        return value.getOnEnter();
    }
}

