/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.utils;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TabSpacesInfo;
import org.eclipse.tm4e.ui.utils.ClassHelper;

public class TextUtils {
    public static boolean isEnter(IDocument d, DocumentCommand c) {
        return c.length == 0 && c.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)c.text) != -1;
    }

    public static String normalizeIndentation(String str, int tabSize, boolean insertSpaces) {
        int firstNonWhitespaceIndex = TextUtils.firstNonWhitespaceIndex(str);
        if (firstNonWhitespaceIndex == -1) {
            firstNonWhitespaceIndex = str.length();
        }
        return String.valueOf(TextUtils.normalizeIndentationFromWhitespace(str.substring(0, firstNonWhitespaceIndex), tabSize, insertSpaces)) + str.substring(firstNonWhitespaceIndex);
    }

    private static String normalizeIndentationFromWhitespace(String str, int tabSize, boolean insertSpaces) {
        int spacesCnt = 0;
        int i = 0;
        while (i < str.length()) {
            spacesCnt = str.charAt(i) == '\t' ? (spacesCnt += tabSize) : ++spacesCnt;
            ++i;
        }
        StringBuilder result = new StringBuilder();
        if (!insertSpaces) {
            long tabsCnt = Math.round(Math.floor(spacesCnt / tabSize));
            spacesCnt %= tabSize;
            int i2 = 0;
            while ((long)i2 < tabsCnt) {
                result.append('\t');
                ++i2;
            }
        }
        int i3 = 0;
        while (i3 < spacesCnt) {
            result.append(' ');
            ++i3;
        }
        return result.toString();
    }

    public static int firstNonWhitespaceIndex(String str) {
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            if (c != ' ' && c != '\t') {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getIndentationAtPosition(IDocument d, int offset) {
        try {
            int p = offset;
            IRegion info = d.getLineInformationOfOffset(p);
            int start = info.getOffset();
            int end = TextUtils.findEndOfWhiteSpace(d, start, offset);
            return d.get(start, end - start);
        }
        catch (BadLocationException badLocationException) {
            return "";
        }
    }

    private static int findEndOfWhiteSpace(IDocument document, int offset, int end) throws BadLocationException {
        while (offset < end) {
            char c = document.getChar(offset);
            if (c != ' ' && c != '\t') {
                return offset;
            }
            ++offset;
        }
        return end;
    }

    public static TabSpacesInfo getTabSpaces(ITextViewer viewer) {
        TabsToSpacesConverter converter = (TabsToSpacesConverter)ClassHelper.getFieldValue((Object)viewer, (String)"fTabsToSpacesConverter", TextViewer.class);
        if (converter != null) {
            int tabSize = (Integer)ClassHelper.getFieldValue((Object)converter, (String)"fTabRatio", TabsToSpacesConverter.class);
            return new TabSpacesInfo(tabSize, true);
        }
        return new TabSpacesInfo(-1, false);
    }
}

