/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.util.ULocale;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class NumberFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public final java.text.NumberFormat numberFormat;
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static ULocale[] availableULocales;
    private static boolean unchecked;
    private static Method integer14API;
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private static final int SCIENTIFICSTYLE = 3;
    private static final int INTEGERSTYLE = 4;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        unchecked = true;
    }

    public NumberFormat(java.text.NumberFormat delegate) {
        this.numberFormat = delegate;
    }

    public NumberFormat() {
        this.numberFormat = java.text.NumberFormat.getInstance();
    }

    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.numberFormat.format(number, toAppendTo, pos);
    }

    public final Object parseObject(String source, ParsePosition parsePosition) {
        return this.numberFormat.parse(source, parsePosition);
    }

    public final String format(double number) {
        return this.numberFormat.format(number);
    }

    public final String format(long number) {
        return this.numberFormat.format(number);
    }

    public final String format(BigInteger number) {
        return this.numberFormat.format(number);
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.numberFormat.format(number, toAppendTo, pos);
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.numberFormat.format(number, toAppendTo, pos);
    }

    public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        return this.numberFormat.format(number, toAppendTo, pos);
    }

    public Number parse(String text, ParsePosition parsePosition) {
        return this.numberFormat.parse(text, parsePosition);
    }

    public Number parse(String text) throws ParseException {
        return this.numberFormat.parse(text);
    }

    public boolean isParseIntegerOnly() {
        return this.numberFormat.isParseIntegerOnly();
    }

    public void setParseIntegerOnly(boolean value) {
        this.numberFormat.setParseIntegerOnly(value);
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(), 0);
    }

    public static NumberFormat getInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 0);
    }

    public static NumberFormat getInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(), 0);
    }

    public static NumberFormat getNumberInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 0);
    }

    public static NumberFormat getNumberInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    public static final NumberFormat getIntegerInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(), 4);
    }

    public static NumberFormat getIntegerInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 4);
    }

    public static NumberFormat getIntegerInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 4);
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(), 1);
    }

    public static NumberFormat getCurrencyInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 1);
    }

    public static NumberFormat getCurrencyInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 1);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(), 2);
    }

    public static NumberFormat getPercentInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 2);
    }

    public static NumberFormat getPercentInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 2);
    }

    public static final NumberFormat getScientificInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(), 3);
    }

    public static NumberFormat getScientificInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 3);
    }

    public static NumberFormat getScientificInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 3);
    }

    public static Locale[] getAvailableLocales() {
        return java.text.NumberFormat.getAvailableLocales();
    }

    public static ULocale[] getAvailableULocales() {
        if (availableULocales == null) {
            Locale[] locales = java.text.NumberFormat.getAvailableLocales();
            ULocale[] ulocales = new ULocale[locales.length];
            int i = 0;
            while (i < locales.length) {
                ulocales[i] = ULocale.forLocale(locales[i]);
                ++i;
            }
            availableULocales = ulocales;
        }
        return (ULocale[])availableULocales.clone();
    }

    public boolean isGroupingUsed() {
        return this.numberFormat.isGroupingUsed();
    }

    public void setGroupingUsed(boolean newValue) {
        this.numberFormat.setGroupingUsed(newValue);
    }

    public int getMaximumIntegerDigits() {
        return this.numberFormat.getMaximumIntegerDigits();
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.numberFormat.setMaximumIntegerDigits(newValue);
    }

    public int getMinimumIntegerDigits() {
        return this.numberFormat.getMinimumIntegerDigits();
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.numberFormat.setMinimumIntegerDigits(newValue);
    }

    public int getMaximumFractionDigits() {
        return this.numberFormat.getMaximumFractionDigits();
    }

    public void setMaximumFractionDigits(int newValue) {
        this.numberFormat.setMaximumFractionDigits(newValue);
    }

    public int getMinimumFractionDigits() {
        return this.numberFormat.getMinimumFractionDigits();
    }

    public void setMinimumFractionDigits(int newValue) {
        this.numberFormat.setMinimumFractionDigits(newValue);
    }

    public String toString() {
        return this.numberFormat.toString();
    }

    public Object clone() {
        return new NumberFormat((java.text.NumberFormat)this.numberFormat.clone());
    }

    public boolean equals(Object obj) {
        try {
            return this.numberFormat.equals(((NumberFormat)obj).numberFormat);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.numberFormat.hashCode();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NumberFormat getInstance(ULocale desiredLocale, int choice) {
        Locale locale = desiredLocale.toLocale();
        java.text.NumberFormat nf = null;
        switch (choice) {
            case 0: {
                nf = java.text.NumberFormat.getInstance(locale);
                return new NumberFormat(nf);
            }
            case 1: {
                nf = java.text.NumberFormat.getCurrencyInstance(locale);
                return new NumberFormat(nf);
            }
            case 2: {
                nf = java.text.NumberFormat.getPercentInstance(locale);
                return new NumberFormat(nf);
            }
            case 3: {
                nf = new DecimalFormat("#E0", new DecimalFormatSymbols(locale));
                nf.setMaximumFractionDigits(10);
                return new NumberFormat(nf);
            }
            case 4: {
                Object[] args;
                if (unchecked) {
                    unchecked = false;
                    try {
                        Class[] classArray = new Class[1];
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            Class<?> clazz2;
                            try {
                                clazz2 = Class.forName("java.util.Locale");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$0 = clazz2;
                        }
                        classArray[0] = clazz;
                        args = classArray;
                        Class<?> clazz3 = class$1;
                        if (clazz3 == null) {
                            Class<?> clazz4;
                            try {
                                clazz4 = Class.forName("java.text.NumberFormat");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz3 = class$1 = clazz4;
                        }
                        integer14API = clazz3.getMethod("getIntegerInstance", (Class<?>[])args);
                    }
                    catch (Exception exception) {}
                }
                if (integer14API != null) {
                    try {
                        args = new Object[]{locale};
                        nf = (java.text.NumberFormat)integer14API.invoke(null, args);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        integer14API = null;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        integer14API = null;
                    }
                    catch (Exception exception) {}
                }
                if (nf != null) return new NumberFormat(nf);
                nf = java.text.NumberFormat.getNumberInstance(locale);
                nf.setMaximumFractionDigits(0);
                nf.setParseIntegerOnly(true);
                return new NumberFormat(nf);
            }
        }
        return new NumberFormat(nf);
    }
}

