/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.syntaxcoloring;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.XtextPresentationReconciler;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.XtextSourceViewerConfiguration;
import org.eclipse.xtext.ui.editor.preferences.IPreferenceStoreAccess;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingPresenter;
import org.eclipse.xtext.ui.editor.syntaxcoloring.HighlightingReconciler;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingHelper;
import org.eclipse.xtext.ui.editor.syntaxcoloring.TextAttributeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HighlightingHelper
implements IHighlightingHelper,
IPropertyChangeListener {
    @Inject
    private Provider<HighlightingReconciler> reconcilerProvider;
    @Inject
    private Provider<HighlightingPresenter> presenterProvider;
    @Inject
    private IPreferenceStoreAccess preferenceStoreAccessor;
    @Inject
    private TextAttributeProvider textAttributeProvider;
    private HighlightingPresenter fPresenter;
    private HighlightingReconciler fReconciler;
    private XtextEditor fEditor;
    private XtextSourceViewer fSourceViewer;
    private XtextSourceViewerConfiguration fConfiguration;
    private XtextPresentationReconciler fPresentationReconciler;
    private IPreferenceStore preferenceStore;

    @Override
    public void install(XtextEditor editor, XtextSourceViewer sourceViewer) {
        this.fEditor = editor;
        this.fSourceViewer = sourceViewer;
        if (this.fEditor != null) {
            this.fConfiguration = editor.getXtextSourceViewerConfiguration();
            this.fPresentationReconciler = (XtextPresentationReconciler)this.fConfiguration.getPresentationReconciler((ISourceViewer)sourceViewer);
        } else {
            this.fConfiguration = null;
            this.fPresentationReconciler = null;
        }
        this.preferenceStore = this.getPreferenceStoreAccessor().getPreferenceStore();
        this.preferenceStore.addPropertyChangeListener((IPropertyChangeListener)this);
        this.enable();
    }

    private void enable() {
        this.fPresenter = (HighlightingPresenter)this.getPresenterProvider().get();
        this.fPresenter.install(this.fSourceViewer, this.fPresentationReconciler);
        if (this.fEditor != null) {
            this.fReconciler = (HighlightingReconciler)this.reconcilerProvider.get();
            this.fReconciler.install(this.fEditor, this.fSourceViewer, this.fPresenter);
        }
    }

    @Override
    public void uninstall() {
        this.disable();
        if (this.preferenceStore != null) {
            this.preferenceStore.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        this.fEditor = null;
        this.fSourceViewer = null;
        this.fConfiguration = null;
        this.fPresentationReconciler = null;
    }

    private void disable() {
        if (this.fReconciler != null) {
            this.fReconciler.uninstall();
            this.fReconciler = null;
        }
        if (this.fPresenter != null) {
            this.fPresenter.uninstall();
            this.fPresenter = null;
        }
    }

    public HighlightingReconciler getReconciler() {
        return this.fReconciler;
    }

    public void setReconcilerProvider(Provider<HighlightingReconciler> reconcilerProvider) {
        this.reconcilerProvider = reconcilerProvider;
    }

    public Provider<HighlightingReconciler> getReconcilerProvider() {
        return this.reconcilerProvider;
    }

    public void setPresenterProvider(Provider<HighlightingPresenter> presenterProvider) {
        this.presenterProvider = presenterProvider;
    }

    public Provider<HighlightingPresenter> getPresenterProvider() {
        return this.presenterProvider;
    }

    public void setPreferenceStoreAccessor(IPreferenceStoreAccess preferenceStoreAccessor) {
        this.preferenceStoreAccessor = preferenceStoreAccessor;
    }

    public IPreferenceStoreAccess getPreferenceStoreAccessor() {
        return this.preferenceStoreAccessor;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.fReconciler != null && event.getProperty().contains(".syntaxColorer.tokenStyles")) {
            this.textAttributeProvider.propertyChange(event);
            this.fReconciler.refresh();
        }
    }
}

