/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.findrefs.IReferenceFinder;
import org.eclipse.xtext.ui.editor.findrefs.SimpleLocalResourceAccess;
import org.eclipse.xtext.ui.refactoring.ElementRenameArguments;
import org.eclipse.xtext.ui.refactoring.IDependentElementsCalculator;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IReferenceUpdater;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.IRenamedElementTracker;
import org.eclipse.xtext.ui.refactoring.impl.IRefactoringDocument;
import org.eclipse.xtext.ui.refactoring.impl.ProjectUtil;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringReferenceQueryDataFactory;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringResourceSetProvider;
import org.eclipse.xtext.ui.refactoring.ui.AbstractLinkedPositionGroupCalculator;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.Strings;

public class SimpleLinkedPositionGroupCalculator
extends AbstractLinkedPositionGroupCalculator {
    @Inject
    private ProjectUtil projectUtil;
    @Inject
    private RefactoringResourceSetProvider resourceSetProvider;
    @Inject
    private IRenameStrategy.Provider strategyProvider;
    @Inject
    private IRenamedElementTracker renamedElementTracker;
    @Inject
    private IDependentElementsCalculator dependentElementsCalculator;
    @Inject
    private RefactoringReferenceQueryDataFactory queryDataFactory;
    @Inject
    private IReferenceFinder referenceFinder;
    @Inject
    private IReferenceUpdater referenceUpdater;

    public LinkedPositionGroup getLinkedPositionGroup(IRenameElementContext renameElementContext, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        XtextEditor editor = (XtextEditor)renameElementContext.getTriggeringEditor();
        IProject project = this.projectUtil.getProject(renameElementContext.getContextResourceURI());
        ResourceSet resourceSet = this.resourceSetProvider.get(project);
        EObject targetElement = resourceSet.getEObject(renameElementContext.getTargetElementURI(), true);
        if (targetElement == null) {
            throw new IllegalStateException("Target element could not be loaded");
        }
        IRenameStrategy renameStrategy = this.strategyProvider.get(targetElement, renameElementContext);
        if (renameStrategy == null) {
            throw new IllegalArgumentException("Cannot find a rename strategy for " + Strings.notNull((Object)renameElementContext.getTargetElementURI()));
        }
        String newName = renameStrategy.getOriginalName();
        Iterable<URI> dependentElementURIs = this.dependentElementsCalculator.getDependentElementURIs(targetElement, (IProgressMonitor)progress.newChild(10));
        LocalResourceRefactoringUpdateAcceptor updateAcceptor = new LocalResourceRefactoringUpdateAcceptor(renameElementContext.getContextResourceURI());
        renameStrategy.createDeclarationUpdates(newName, resourceSet, updateAcceptor);
        Map<URI, URI> original2newEObjectURI = this.renamedElementTracker.renameAndTrack(Iterables.concat(Collections.singleton(renameElementContext.getTargetElementURI()), dependentElementURIs), newName, resourceSet, renameStrategy, (IProgressMonitor)progress.newChild(10));
        ElementRenameArguments elementRenameArguments = new ElementRenameArguments(renameElementContext.getTargetElementURI(), newName, renameStrategy, original2newEObjectURI);
        IReferenceFinder.IQueryData queryData = this.queryDataFactory.create(elementRenameArguments);
        final ArrayList referenceDescriptions = Lists.newArrayList();
        IAcceptor<IReferenceDescription> referenceAcceptor = new IAcceptor<IReferenceDescription>(){

            public void accept(IReferenceDescription referenceDescription) {
                referenceDescriptions.add(referenceDescription);
            }
        };
        if (renameElementContext.getTargetElementURI().trimFragment().equals((Object)renameElementContext.getContextResourceURI())) {
            this.referenceFinder.findLocalReferences(queryData, new SimpleLocalResourceAccess(resourceSet), referenceAcceptor, (IProgressMonitor)progress.newChild(60));
        } else {
            this.referenceFinder.findIndexedReferences(queryData, renameElementContext.getContextResourceURI(), referenceAcceptor, (IProgressMonitor)progress.newChild(60));
        }
        this.referenceUpdater.createReferenceUpdates(elementRenameArguments, referenceDescriptions, updateAcceptor, (IProgressMonitor)progress.newChild(10));
        List<ReplaceEdit> textEdits = updateAcceptor.getTextEdits();
        LinkedPositionGroup linkedGroup = this.createLinkedGroupFromReplaceEdits(textEdits, editor, renameStrategy.getOriginalName(), progress.newChild(10));
        return linkedGroup;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LocalResourceRefactoringUpdateAcceptor
    implements IRefactoringUpdateAcceptor {
        private List<ReplaceEdit> textEdits = Lists.newArrayList();
        private final URI localResourceURI;

        public LocalResourceRefactoringUpdateAcceptor(URI localResourceURI) {
            this.localResourceURI = localResourceURI;
        }

        public List<ReplaceEdit> getTextEdits() {
            return this.textEdits;
        }

        @Override
        public RefactoringStatus getRefactoringStatus() {
            return null;
        }

        @Override
        public IRefactoringDocument getDocument(URI resourceURI) {
            return null;
        }

        @Override
        public Change createCompositeChange(String name, IProgressMonitor monitor) {
            return null;
        }

        @Override
        public void accept(URI resourceURI, Change change) {
        }

        @Override
        public void accept(URI resourceURI, TextEdit textEdit) {
            if (this.localResourceURI.equals((Object)resourceURI) && textEdit instanceof ReplaceEdit) {
                this.textEdits.add((ReplaceEdit)textEdit);
            }
        }
    }
}

