/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.utils;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters093.utils.PUDefinition_IPCData;
import org.jdom2.Document;
import org.jdom2.Element;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.2"})
public class HWCacheBuilder
implements ICache {
    public static final Logger LOGGER = LoggerFactory.getLogger(HWCacheBuilder.class);
    private final HashMap<File, Map<String, Object>> map = new HashMap();

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        LOGGER.info("Build up HWCache for 0.9.2");
        HashMap<String, PUDefinition_IPCData> hashMap = new HashMap<String, PUDefinition_IPCData>();
        PUDefinition_IPCData cache = new PUDefinition_IPCData();
        hashMap.put("globalCache", cache);
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            Element hWModelElement;
            Element rootElement;
            File targetFile = entry.getKey();
            Document document1 = entry.getValue();
            this.map.put(targetFile, hashMap);
            if (document1 == null || (rootElement = document1.getRootElement()) == null || (hWModelElement = rootElement.getChild("hwModel")) == null) continue;
            List featureCategoriesList = hWModelElement.getChildren("featureCategories");
            for (Element featureCategoriesElement : featureCategoriesList) {
                String featureCategoryName = featureCategoriesElement.getAttributeValue("name");
                List featuresList = featureCategoriesElement.getChildren("features");
                for (Element featureElement : featuresList) {
                    String featureName = featureElement.getAttributeValue("name");
                    String featureValue = featureElement.getAttributeValue("value");
                    String ipcFeatureKey = String.valueOf(HelperUtil.encodeName((String)featureCategoryName)) + "/" + HelperUtil.encodeName((String)featureName) + "?type=HwFeature";
                    double parseDouble = Double.parseDouble(featureValue);
                    cache.getIpcFeatureValueMap().put(ipcFeatureKey, parseDouble);
                }
            }
            List definitionsList = hWModelElement.getChildren("definitions");
            for (Element definitionsElement : definitionsList) {
                String puDefinitionName = definitionsElement.getAttributeValue("name");
                Map features = HelperUtil.getMultipleElementsNameandTypeFromAttributeOrChildeElement((String)"features", (Element)definitionsElement);
                Set keySet = features.keySet();
                List ipcHwFeatures = keySet.stream().filter(st -> st.startsWith("Instructions/IPC") || st.startsWith("Instructions/ipc")).collect(Collectors.toList());
                if (ipcHwFeatures.isEmpty()) continue;
                if (ipcHwFeatures.size() > 1) {
                    LOGGER.error("ProcessingUnitDefinition : \"{}\" contains multiple HwFeatures of type IPC. In this case, only the first HwFeature : {} will be considered for runtime info calculation", (Object)puDefinitionName, ipcHwFeatures.get(0));
                }
                cache.getPuDefinitionIPCFeatureMap().put(HelperUtil.encodeName((String)puDefinitionName), String.valueOf((String)ipcHwFeatures.get(0)) + "?type=HwFeature");
            }
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

