/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.common.postprocessor;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.app4mc.amalthea.converters.common.base.IPostProcessor;
import org.eclipse.app4mc.amalthea.converters.common.postprocessor.ElementRef;
import org.eclipse.app4mc.amalthea.converters.common.postprocessor.XSDElement;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.jdom2.Document;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomPropsPostProcessor
implements IPostProcessor {
    private static final String HREF = "href";
    private static final String VALUE = "value";
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomPropsPostProcessor.class);

    @Override
    public void process(Map<File, Document> fileName2documentMap) {
        HashMap map_values_to_be_investigated = new HashMap();
        boolean areXMIIDsUsed = false;
        HashMap<File, Map<String, List<Element>>> idElementsCacheMap = new HashMap();
        for (Map.Entry<File, Document> entry : fileName2documentMap.entrySet()) {
            File targetFile = entry.getKey();
            Document root = entry.getValue();
            if (root == null) {
                return;
            }
            Element rootElement = root.getRootElement();
            HashMap refCustomProps2ObjectsMap = new HashMap();
            StringBuilder xpathBuffer = new StringBuilder();
            xpathBuffer.append(".//customProperties/value[@xsi:type=\"common:ReferenceObject\"]");
            xpathBuffer.append("|");
            xpathBuffer.append(".//customProperties/value/values[@xsi:type=\"common:ReferenceObject\"]");
            List<Element> value_custProps_refObjects = HelperUtil.getXpathResult(rootElement, xpathBuffer.toString(), Element.class, AmaltheaNamespaceRegistry.getGenericNamespace("xsi"));
            for (Element element : value_custProps_refObjects) {
                String attributeValue = element.getAttributeValue(VALUE);
                if (attributeValue == null) {
                    String string = attributeValue = element.getChild(VALUE) != null ? element.getChild(VALUE).getAttributeValue(HREF) : null;
                }
                if (attributeValue == null) continue;
                if (!refCustomProps2ObjectsMap.containsKey(attributeValue)) {
                    refCustomProps2ObjectsMap.put(attributeValue, new ArrayList());
                }
                ((List)refCustomProps2ObjectsMap.get(attributeValue)).add(element);
                if (areXMIIDsUsed || this.isURIFragment(attributeValue)) continue;
                areXMIIDsUsed = true;
            }
            map_values_to_be_investigated.put(targetFile, refCustomProps2ObjectsMap);
        }
        if (areXMIIDsUsed) {
            idElementsCacheMap = this.buildCache(fileName2documentMap);
        }
        HashMap<String, File> refFileInfoMap = new HashMap<String, File>();
        Map<String, List<XSDElement>> tags2refbaseObjectsMap = this.populateInfoOfAmaltheModelTags_111_Content();
        for (Map.Entry entry : map_values_to_be_investigated.entrySet()) {
            File modelFile = (File)entry.getKey();
            Map map = (Map)entry.getValue();
            if (map == null) continue;
            for (Map.Entry entry2 : map.entrySet()) {
                String refString = (String)entry2.getKey();
                List values = (List)entry2.getValue();
                boolean isRefBaseObjectType = true;
                if (!this.isURIFragment(refString)) {
                    int indexOfHash = refString.indexOf(35);
                    if (indexOfHash != -1) {
                        String fileName = refString.substring(0, indexOfHash);
                        String id = refString.substring(indexOfHash + 1);
                        File refFile = this.getRefFile(modelFile, refFileInfoMap, fileName);
                        Map.Entry<Boolean, ElementRef> result = this.isElementOfRefBaseObject(refFile, id, idElementsCacheMap, tags2refbaseObjectsMap);
                        isRefBaseObjectType = result.getKey();
                        ElementRef elementRef = result.getValue();
                        this.updateTypeForAllElements(values, elementRef != null ? elementRef.getType() : null);
                    } else {
                        Map.Entry<Boolean, ElementRef> result = this.isElementOfRefBaseObject(modelFile, refString, idElementsCacheMap, tags2refbaseObjectsMap);
                        isRefBaseObjectType = result.getKey();
                    }
                } else {
                    ElementRef elementRef = CustomPropsPostProcessor.elementRefBuilder(refString);
                    isRefBaseObjectType = this.isElementOfRefBaseObject(elementRef, tags2refbaseObjectsMap);
                }
                if (isRefBaseObjectType) continue;
                this.detachElements(values);
            }
        }
    }

    private boolean isElementOfRefBaseObject(ElementRef elementRef, Map<String, List<XSDElement>> tags2refbaseObjectsMap) {
        List<XSDElement> list = tags2refbaseObjectsMap.get(elementRef.getName());
        if (list != null) {
            ElementRef parentRef = elementRef.getParentRef();
            String parentName = parentRef.getName();
            String parentType = parentRef.getType();
            boolean isParentSame = false;
            block0: for (XSDElement elementRef2 : list) {
                Set<XSDElement> parentRefs = elementRef2.getParentRefs();
                for (XSDElement xsdElementRef : parentRefs) {
                    if (parentName != null) {
                        if (!xsdElementRef.getName().equals(parentName)) continue;
                        if (elementRef.getType() == null) {
                            elementRef.setType(elementRef2.getType());
                        }
                        isParentSame = true;
                        break block0;
                    }
                    if (parentType == null || !xsdElementRef.getType().equals(parentType)) continue;
                    isParentSame = true;
                    break block0;
                }
            }
            return isParentSame;
        }
        return false;
    }

    private Map.Entry<Boolean, ElementRef> isElementOfRefBaseObject(File refFile, String id, Map<File, Map<String, List<Element>>> idElementsCacheMap, Map<String, List<XSDElement>> tags2refbaseObjectsMap) {
        List<Element> elements;
        Map<String, List<Element>> map = idElementsCacheMap.get(refFile);
        if (map != null && (elements = map.get(id)) != null) {
            for (Element element2 : elements) {
                ElementRef elementRef = this.elementRefBuilder(element2);
                boolean result = this.isElementOfRefBaseObject(elementRef, tags2refbaseObjectsMap);
                if (!result) continue;
                return new AbstractMap.SimpleEntry<Boolean, ElementRef>(true, elementRef);
            }
        }
        return new AbstractMap.SimpleEntry<Boolean, Object>(false, null);
    }

    private void detachElements(List<Element> values) {
        for (Element element : values) {
            String tag_name = element.getName();
            String key = "";
            if (tag_name.equals(VALUE)) {
                key = element.getParentElement() != null ? element.getParentElement().getAttributeValue("key") : null;
            } else if (tag_name.equals("values")) {
                String string = element.getParentElement() != null ? (element.getParentElement().getParentElement() != null ? element.getParentElement().getParentElement().getAttributeValue("key") : null) : (key = null);
            }
            if (key != null) {
                LOGGER.warn("Value of CustomProperty  : {} is removed (as it is not inheriting RefereableBaseObject)", (Object)key);
            }
            element.detach();
        }
    }

    private void updateTypeForAllElements(List<Element> values, String type) {
        if (type == null) {
            return;
        }
        for (Element element : values) {
            String attributeValue;
            Element child = element.getChild(VALUE);
            if (child == null || (attributeValue = child.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace("xsi"))) != null) continue;
            child.setAttribute("type", type, AmaltheaNamespaceRegistry.getGenericNamespace("xsi"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, List<XSDElement>> populateInfoOfAmaltheModelTags_111_Content() {
        HashMap<String, List<XSDElement>> map = new HashMap<String, List<XSDElement>>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                InputStream inputStream = this.getInputStream();
                try {
                    try (BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));){
                        String inputLine;
                        while ((inputLine = in.readLine()) != null) {
                            StringTokenizer tokenizer = new StringTokenizer(inputLine, ",");
                            XSDElement parentElement = null;
                            XSDElement processingElement = null;
                            boolean isTagToProcess = true;
                            boolean isTagTypeToProcess = false;
                            while (tokenizer.hasMoreTokens()) {
                                String nextToken = tokenizer.nextToken();
                                if (isTagToProcess) {
                                    processingElement = new XSDElement();
                                    processingElement.setName(nextToken);
                                    isTagToProcess = false;
                                    isTagTypeToProcess = true;
                                    continue;
                                }
                                if (!isTagTypeToProcess || processingElement == null) continue;
                                processingElement.setType(nextToken);
                                if (!map.containsKey(processingElement.getName())) {
                                    map.put(processingElement.getName(), new ArrayList());
                                    ((List)map.get(processingElement.getName())).add(processingElement);
                                } else {
                                    List existingElements = (List)map.get(processingElement.getName());
                                    boolean isElementWithSamePropsExisting = false;
                                    for (XSDElement xsdElementRef : existingElements) {
                                        if (!processingElement.getName().equals(xsdElementRef.getName()) || !processingElement.getType().equals(xsdElementRef.getType())) continue;
                                        processingElement = xsdElementRef;
                                        isElementWithSamePropsExisting = true;
                                        break;
                                    }
                                    if (!isElementWithSamePropsExisting) {
                                        ((List)map.get(processingElement.getName())).add(processingElement);
                                    }
                                }
                                if (parentElement != null) {
                                    processingElement.getParentRefs().add(parentElement);
                                }
                                parentElement = processingElement;
                                isTagTypeToProcess = false;
                                isTagToProcess = true;
                            }
                        }
                    }
                    if (inputStream == null) return map;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
                return map;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    private InputStream getInputStream() throws IOException {
        if (System.getProperty("junit:tags_Elements_ReferableBaseObject") != null) {
            return new FileInputStream(new File(System.getProperty("junit:tags_Elements_ReferableBaseObject")));
        }
        URL url = new URL("platform:/plugin/org.eclipse.app4mc.amalthea.converters.common/resources/tags_Elements_ReferableBaseObject.txt");
        return url.openConnection().getInputStream();
    }

    private ElementRef elementRefBuilder(Element node) {
        String tagName = node.getName();
        ElementRef elementRef = new ElementRef();
        elementRef.setName(tagName);
        elementRef.setType(node.getAttributeValue("type", AmaltheaNamespaceRegistry.getGenericNamespace("xsi")));
        ElementRef parentElementRef = CustomPropsPostProcessor.addParentElementRef(node, elementRef);
        if (parentElementRef != null) {
            elementRef.setParentRef(parentElementRef);
        }
        return elementRef;
    }

    private static ElementRef addParentElementRef(Element node, ElementRef elementRef) {
        Element parentElement = node.getParentElement();
        if (parentElement != null) {
            String parentTagName = String.valueOf(parentElement.getName()) + (parentElement.getNamespacePrefix() != null ? parentElement.getNamespacePrefix() : "");
            ElementRef parentElementRef = new ElementRef();
            if (parentTagName.contains(":")) {
                parentElementRef.setType(parentTagName);
            } else {
                parentElementRef.setName(parentTagName);
            }
            return parentElementRef;
        }
        return null;
    }

    private static ElementRef elementRefBuilder(String refString) {
        ElementRef elementRef = null;
        ElementRef parentElementRef = null;
        char[] charArray = refString.toCharArray();
        boolean isBuildingElement = false;
        StringBuilder nameBuffer = new StringBuilder();
        int i = 0;
        while (i < charArray.length) {
            if (charArray[i] == '/') {
                if (nameBuffer.length() > 0 && elementRef != null) {
                    elementRef.setName(nameBuffer.toString());
                    if (parentElementRef != null) {
                        elementRef.setParentRef(parentElementRef);
                    }
                    parentElementRef = elementRef;
                    nameBuffer.setLength(0);
                }
                isBuildingElement = false;
                int lookUp = i + 1;
                if (lookUp < charArray.length && charArray[lookUp] == '/') {
                    ++i;
                    if (++lookUp < charArray.length && charArray[lookUp] == '@') {
                        ++i;
                        isBuildingElement = true;
                        elementRef = new ElementRef();
                    }
                } else if (charArray[lookUp] == '@') {
                    ++i;
                    isBuildingElement = true;
                    elementRef = new ElementRef();
                }
            } else if (charArray[i] == '.') {
                isBuildingElement = false;
            } else if (isBuildingElement) {
                nameBuffer.append(charArray[i]);
            }
            ++i;
        }
        if (nameBuffer.length() > 0 && elementRef != null) {
            elementRef.setName(nameBuffer.toString());
            if (parentElementRef != null) {
                elementRef.setParentRef(parentElementRef);
            }
            nameBuffer.setLength(0);
        }
        return elementRef;
    }

    private Map<File, Map<String, List<Element>>> buildCache(Map<File, Document> fileName2documentMap) {
        HashMap<File, Map<String, List<Element>>> cacheMap = new HashMap<File, Map<String, List<Element>>>();
        for (Map.Entry<File, Document> entry : fileName2documentMap.entrySet()) {
            File targetFile = entry.getKey();
            Document root = entry.getValue();
            List<Element> elements = HelperUtil.getXpathResult(root, ".//*[@xmi:id]", Element.class, AmaltheaNamespaceRegistry.getGenericNamespace("xmi"));
            for (Element element : elements) {
                String id = element.getAttributeValue("id", AmaltheaNamespaceRegistry.getGenericNamespace("xmi"));
                if (!cacheMap.containsKey(targetFile)) {
                    cacheMap.put(targetFile, new HashMap());
                }
                if (!((Map)cacheMap.get(targetFile)).containsKey(id)) {
                    ((Map)cacheMap.get(targetFile)).put(id, new ArrayList());
                }
                ((List)((Map)cacheMap.get(targetFile)).get(id)).add(element);
            }
        }
        return cacheMap;
    }

    private boolean isURIFragment(String string) {
        if (string.contains("#")) {
            return string.substring(string.indexOf(35) + 1).contains("/");
        }
        return string.contains("/");
    }

    protected File getRefFile(File targetFile, HashMap<String, File> refFileInfoMap, String fileNameInfo) {
        File referredFile = null;
        if (!refFileInfoMap.containsKey(fileNameInfo)) {
            referredFile = new File(fileNameInfo);
            if (!referredFile.exists() && !(referredFile = new File(targetFile.getParent(), fileNameInfo)).exists()) {
                referredFile = null;
                LOGGER.error("Unable to find the referred file : {}", (Object)fileNameInfo);
            }
            refFileInfoMap.put(fileNameInfo, referredFile);
        } else {
            referredFile = refFileInfoMap.get(fileNameInfo);
        }
        return referredFile;
    }
}

