/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters095.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.9.4", "output_model_version=0.9.5"}, service={IConverter.class})
public class SwConverter
extends AbstractConverter {
    private static final String TYPE = "type";
    private static final String ITEMS = "items";
    private static final Namespace XSI_NAMESPACE = AmaltheaNamespaceRegistry.getGenericNamespace((String)"xsi");
    @Reference
    SessionLogger logger;

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        this.logger.info("Migration from 0.9.4 to 0.9.5 : Executing Sw converter for model file : {0}", new Object[]{targetFile.getName()});
        this.basicConvert(targetFile, filename2documentMap);
    }

    public void basicConvert(File file, Map<File, Document> map) {
        Document document = map.get(file);
        if (document == null) {
            return;
        }
        Element rootElement = document.getRootElement();
        this.updateGraphEntries(rootElement);
        this.updateCallSequences(rootElement);
        this.updateRunnableItems(rootElement);
        this.updateRunnableModeSwitches(rootElement);
        this.updateRunnableProbabilitySwitches(rootElement);
    }

    private void updateGraphEntries(Element rootElement) {
        String xpath = "./swModel/tasks/callGraph/graphEntries|./swModel/isrs/callGraph/graphEntries";
        List entries = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/tasks/callGraph/graphEntries|./swModel/isrs/callGraph/graphEntries", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), XSI_NAMESPACE});
        for (Element graphEntry : entries) {
            graphEntry.setName(ITEMS);
        }
    }

    private void updateCallSequences(Element rootElement) {
        String xpath = "./swModel/tasks//*[@xsi:type=\"am:CallSequence\"]|./swModel/isrs//*[@xsi:type=\"am:CallSequence\"]";
        List callSequences = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/tasks//*[@xsi:type=\"am:CallSequence\"]|./swModel/isrs//*[@xsi:type=\"am:CallSequence\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), XSI_NAMESPACE});
        for (Element cs : callSequences) {
            cs.setAttribute(TYPE, "am:Group", XSI_NAMESPACE);
            String oldName = cs.getAttributeValue("name");
            if (oldName == null || oldName.isEmpty()) {
                cs.setAttribute("name", "CallSequence");
            }
            cs.setAttribute("ordered", "true");
            for (Element call : cs.getChildren()) {
                Element counter;
                call.setName(ITEMS);
                String callType = call.getAttributeValue(TYPE, XSI_NAMESPACE);
                if ("am:TaskRunnableCall".equals(callType)) {
                    call.setAttribute(TYPE, "am:RunnableCall", XSI_NAMESPACE);
                }
                if ("am:InterProcessTrigger".equals(callType) || (counter = call.getChild("counter")) == null) continue;
                this.migrateCounterToCustomProps(call, counter);
            }
        }
    }

    private void migrateCounterToCustomProps(Element callSequenceItem, Element counter) {
        Attribute prescaler = counter.getAttribute("prescaler");
        Attribute offset = counter.getAttribute("offset");
        if (prescaler != null) {
            this.createCounterCustomProps(callSequenceItem, "counter-prescaler", prescaler.getValue());
        }
        if (offset != null) {
            this.createCounterCustomProps(callSequenceItem, "counter-offset", offset.getValue());
        }
        counter.detach();
    }

    private void createCounterCustomProps(Element callSequenceItem, String key, String val) {
        Element customProps = new Element("customProperties");
        customProps.setAttribute("key", key);
        Element customVal = new Element("value");
        customVal.setAttribute(TYPE, "am:IntegerObject", XSI_NAMESPACE);
        customVal.setAttribute("value", val);
        customProps.addContent((Content)customVal);
        callSequenceItem.addContent((Content)customProps);
    }

    private void updateRunnableItems(Element rootElement) {
        String xpath = "./swModel/runnables";
        List runnables = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), XSI_NAMESPACE});
        for (Element runnable : runnables) {
            Element callGraph = new Element("callGraph");
            runnable.addContent((Content)callGraph);
            ArrayList runnableItems = new ArrayList(runnable.getChildren("runnableItems"));
            for (Element item : runnableItems) {
                item.setName(ITEMS);
                item.detach();
                callGraph.addContent((Content)item);
            }
        }
    }

    private void updateRunnableModeSwitches(Element rootElement) {
        String xpath = "./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]";
        List switches = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables//*[@xsi:type=\"am:RunnableModeSwitch\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), XSI_NAMESPACE});
        for (Element elem : switches) {
            elem.setAttribute(TYPE, "am:ModeSwitch", XSI_NAMESPACE);
        }
    }

    private void updateRunnableProbabilitySwitches(Element rootElement) {
        String xpath = "./swModel/runnables//*[@xsi:type=\"am:RunnableProbabilitySwitch\"]";
        List switches = HelperUtil.getXpathResult((Element)rootElement, (String)"./swModel/runnables//*[@xsi:type=\"am:RunnableProbabilitySwitch\"]", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((String)this.getOutputModelVersion(), (String)"am"), XSI_NAMESPACE});
        for (Element elem : switches) {
            elem.setAttribute(TYPE, "am:ProbabilitySwitch", XSI_NAMESPACE);
        }
    }
}

