/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters081.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters081.utils.ConstraintElementsCacheEnum;
import org.eclipse.app4mc.util.sessionlog.SessionLogger;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"input_model_version=0.8.0"})
public class ConstraintElementsCacheBuilder
implements ICache {
    private final HashMap<File, Map<String, Object>> map = new HashMap();
    @Reference
    SessionLogger logger;

    public void buildCache(Map<File, Document> fileDocumentMapping) {
        if (this.logger != null) {
            this.logger.info("Build up ConstraintElementsCache for 0.8.0", new Object[0]);
        }
        for (Map.Entry<File, Document> entry : fileDocumentMapping.entrySet()) {
            File targetFile = entry.getKey();
            Document document = entry.getValue();
            if (document == null) continue;
            Element rootElement = document.getRootElement();
            Map<String, Object> fileCache = this.map.get(targetFile);
            if (fileCache == null) {
                fileCache = new HashMap<String, Object>();
                this.map.put(targetFile, fileCache);
            }
            ArrayList<String> rootEventChainNames = new ArrayList<String>();
            fileCache.put(ConstraintElementsCacheEnum.ROOT_EVENTCHAIN_NAMES.name(), rootEventChainNames);
            List rootEventChainElements = HelperUtil.getXpathResult((Element)rootElement, (String)"./constraintsModel/eventChains", Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion.VERSION_070, (String)"am")});
            for (Element element : rootEventChainElements) {
                String eventChainName = element.getAttributeValue("name");
                if (eventChainName == null) continue;
                rootEventChainNames.add(HelperUtil.encodeName((String)eventChainName));
            }
        }
    }

    public Map<File, Map<String, Object>> getCacheMap() {
        return this.map;
    }

    public void clearCacheMap() {
        this.map.clear();
    }
}

