/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters.ui.jobs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.converters.common.MigrationException;
import org.eclipse.app4mc.amalthea.converters.common.MigrationHelper;
import org.eclipse.app4mc.amalthea.converters.common.MigrationInputFile;
import org.eclipse.app4mc.amalthea.converters.common.MigrationProcessor;
import org.eclipse.app4mc.amalthea.converters.common.MigrationSettings;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters.ui.dialog.MigrationResultDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;

public class ModelMigrationJob
extends Job {
    private final MigrationProcessor migrationProcessor;
    private final ArrayList<MigrationSettings> migrationSettings = new ArrayList();
    private IProject project;

    public ModelMigrationJob(String name, MigrationProcessor migrationProcessor, MigrationSettings migrationSettings, IProject project) {
        super(name);
        this.migrationProcessor = migrationProcessor;
        this.project = project;
        Map<String, Map<String, List<MigrationInputFile>>> collect = migrationSettings.getMigModelFiles().stream().collect(Collectors.groupingBy(mig -> mig.getOriginalFile().getParent(), Collectors.groupingBy(MigrationInputFile::getModelVersion)));
        for (Map.Entry<String, Map<String, List<MigrationInputFile>>> folderMapping : collect.entrySet()) {
            for (Map.Entry<String, List<MigrationInputFile>> versionMapping : folderMapping.getValue().entrySet()) {
                MigrationSettings settings = new MigrationSettings();
                settings.setInputModelVersion(versionMapping.getKey());
                settings.setMigrationModelVersion(migrationSettings.getMigrationModelVersion());
                settings.setProject(migrationSettings.getProject());
                settings.setOutputDirectoryLocation(versionMapping.getValue().get(0).getOriginalFile().getParent());
                settings.setCreateBackupFile(migrationSettings.isCreateBackupFile());
                settings.getMigModelFiles().addAll((Collection)versionMapping.getValue());
                this.migrationSettings.add(settings);
            }
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        boolean cancelled = false;
        LinkedHashMap<String, String> results = new LinkedHashMap<String, String>();
        try {
            for (MigrationSettings settings : this.migrationSettings) {
                String ident = settings.getProject().toURI().relativize(((MigrationInputFile)settings.getMigModelFiles().get(0)).getOriginalFile().getParentFile().toURI()).getPath();
                if (cancelled) {
                    results.put(ident, "Migration cancelled.");
                    continue;
                }
                boolean inputValid = true;
                try {
                    inputValid = MigrationHelper.isInputModelVersionValid((MigrationSettings)settings);
                }
                catch (MigrationException e) {
                    results.put(ident, "Error during migration: " + e.getLocalizedMessage());
                    continue;
                }
                if (!inputValid) {
                    results.put(ident, "Model migration stopped as selected model files belong to different versions.");
                    continue;
                }
                if (settings.getInputModelVersion() != null && settings.getInputModelVersion().equals(settings.getMigrationModelVersion())) {
                    results.put(ident, "Selected models are compatible to latest AMALTHEA meta-model version (" + settings.getMigrationModelVersion() + "). It is not required to migrate these models !!");
                    continue;
                }
                if (!ModelVersion.isValidVersion((String)settings.getMigrationModelVersion())) {
                    results.put(ident, "The AMALTHEA meta-model version (" + settings.getMigrationModelVersion() + ") is not supported by the migration component !!");
                    continue;
                }
                if (settings.getInputModelVersion() != null && settings.getMigrationModelVersion() != null && ModelVersion.getModelVersion((String)settings.getInputModelVersion()).ordinal() > ModelVersion.getModelVersion((String)settings.getMigrationModelVersion()).ordinal()) {
                    results.put(ident, "The target model version (" + settings.getMigrationModelVersion() + ") is older than the input model version (" + settings.getInputModelVersion() + "). " + "A backwards migration is not supported !!");
                    continue;
                }
                boolean backupSucceeded = true;
                if (settings.isCreateBackupFile()) {
                    for (MigrationInputFile input : settings.getMigModelFiles()) {
                        backupSucceeded = MigrationHelper.createBackupFile((MigrationInputFile)input);
                    }
                }
                if (backupSucceeded) {
                    try {
                        int result = this.migrationProcessor.execute(settings, monitor);
                        switch (result) {
                            case 20: {
                                results.put(ident, "Migration not supported for the selected model versions. Input Model version : \"" + settings.getInputModelVersion() + "\" Output Model Version : \"" + settings.getMigrationModelVersion() + "\"");
                                break;
                            }
                            case 40: {
                                results.put(ident, "Migration cancelled.");
                                cancelled = true;
                                break;
                            }
                            case 30: {
                                results.put(ident, "Error during migration !!");
                                break;
                            }
                            case 10: {
                                results.put(ident, "Model Migration successful !!");
                                break;
                            }
                        }
                    }
                    catch (MigrationException e) {
                        results.put(ident, "Error during migration: " + e.getLocalizedMessage());
                    }
                    continue;
                }
                results.put(ident, "Migration Stopped : Source files could not be backed up before migration in " + ((MigrationInputFile)settings.getMigModelFiles().get(0)).getProjectRelativePath());
            }
        }
        finally {
            this.migrationSettings.forEach(MigrationSettings::close);
        }
        Display.getDefault().asyncExec(() -> {
            MigrationResultDialog dialog = new MigrationResultDialog(Display.getDefault().getActiveShell(), results);
            dialog.open();
            if (this.project != null) {
                try {
                    this.project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    Platform.getLog(((Object)((Object)this)).getClass()).error(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (family != null && "AMALTHEA_MODEL_MIGRATION".equals(family)) {
            return true;
        }
        return super.belongsTo(family);
    }
}

