/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.hw;

import java.io.File;
import javax.inject.Named;
import org.eclipse.app4mc.amalthea.model.HWModel;
import org.eclipse.app4mc.amalthea.visualization.hw.DiagramLocation;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisualizationHandler {
    private static final String PROPERTY_GRAPHVIZ_DOT = "GRAPHVIZ_DOT";
    private static final Logger LOGGER = LoggerFactory.getLogger(VisualizationHandler.class);

    @Execute
    public void execute(Shell shell, UISynchronize sync, @Optional @Preference(nodePath="net.sourceforge.plantuml.eclipse", value="graphvizPath") String dotPath, @Named(value="org.eclipse.ui.selection") @Named(value="org.eclipse.ui.selection") IStructuredSelection selection) {
        if (!selection.isEmpty() && !(selection.getFirstElement() instanceof HWModel)) {
            LOGGER.info("No HWModel selected!");
            return;
        }
        HWModel hwModel = (HWModel)selection.getFirstElement();
        DiagramLocation diagramLocation = new DiagramLocation(hwModel);
        if (!diagramLocation.isValid()) {
            return;
        }
        this.execute(shell, sync, dotPath, hwModel, diagramLocation, true, null);
    }

    public void execute(Shell shell, UISynchronize sync, String dotPathFromPlantUMLPreferencePage, HWModel hwModel, DiagramLocation diagramLocation, boolean showSuccessInfo, IJobChangeListener listener) {
        String dotPathFromSystemProperty = System.getenv(PROPERTY_GRAPHVIZ_DOT);
        File dotFile = null;
        if (dotPathFromPlantUMLPreferencePage != null) {
            dotFile = this.ensureValidDotFile(shell, sync, dotPathFromPlantUMLPreferencePage, "PlantUMLPreference");
        } else if (dotPathFromSystemProperty != null) {
            dotFile = this.ensureValidDotFile(shell, sync, dotPathFromSystemProperty, "SystemProperty");
        } else {
            this.showErrorDialog(shell, sync, "Missing Graphviz dot.exe location.\nPlease specify location via Window - Preferences - PlantUML - Path to the dot executable of Graphviz.");
        }
        if (dotFile == null) {
            return;
        }
        System.setProperty(PROPERTY_GRAPHVIZ_DOT, dotFile.getAbsolutePath());
        LOGGER.info("GRAPHVIZ_DOT: {}", (Object)System.getProperty(PROPERTY_GRAPHVIZ_DOT));
        Job job = Job.create((String)"Generate diagram", monitor -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        if (listener != null) {
            job.addJobChangeListener(listener);
        }
        job.schedule();
    }

    private File ensureValidDotFile(Shell shell, UISynchronize sync, String dotPath, String origin) {
        if (dotPath == null || dotPath.equals("")) {
            this.showErrorDialog(shell, sync, "Missing Graphviz dot.exe location.\nPlease specify location via Window - Preferences - PlantUML - Path to the dot executable of Graphviz.");
            return null;
        }
        File dotFile = new File(dotPath);
        if (!dotFile.canExecute()) {
            if (origin.equals("PlantUMLPreference")) {
                this.showErrorDialog(shell, sync, "Invalid Graphviz dot.exe location: '" + dotFile.getAbsolutePath() + "'" + "\nPlease set location via Window - Preferences - PlantUML - Path to the 'dot executable of Graphviz'.");
            } else {
                this.showErrorDialog(shell, sync, "Invalid Graphviz dot.exe location found in System Property 'GRAPHVIZ_DOT' : '" + dotFile.getAbsolutePath() + "'" + "\nPlease update the System Property 'GRAPHVIZ_DOT' with valid Path to the 'dot executable of Graphviz'.");
            }
            return null;
        }
        return dotFile;
    }

    private void showInfoDialog(Shell shell, UISynchronize sync, String message) {
        sync.asyncExec(() -> MessageDialog.openInformation((Shell)shell, (String)"AMALTHEA HW Visualization", (String)message));
    }

    private void showErrorDialog(Shell shell, UISynchronize sync, String message) {
        sync.asyncExec(() -> MessageDialog.openError((Shell)shell, (String)"AMALTHEA HW Visualization", (String)message));
    }
}

