/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.standard;

import javafx.embed.swt.FXCanvas;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.chart.AreaChart;
import javafx.scene.chart.NumberAxis;
import javafx.scene.chart.ValueAxis;
import javafx.scene.chart.XYChart;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.annotation.PostConstruct;
import org.apache.commons.math3.distribution.BetaDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.distribution.WeibullDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueBetaDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueBoundaries;
import org.eclipse.app4mc.amalthea.model.ContinuousValueGaussDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogram;
import org.eclipse.app4mc.amalthea.model.ContinuousValueHistogramEntry;
import org.eclipse.app4mc.amalthea.model.ContinuousValueStatistics;
import org.eclipse.app4mc.amalthea.model.ContinuousValueUniformDistribution;
import org.eclipse.app4mc.amalthea.model.ContinuousValueWeibullEstimatorsDistribution;
import org.eclipse.app4mc.amalthea.model.IContinuousValueDeviation;
import org.eclipse.app4mc.amalthea.model.util.WeibullUtil;
import org.eclipse.app4mc.amalthea.visualizations.standard.AbstractDeviationChart;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Probability Density Diagram (continuous values)", "description=Visualize the Probability Density Function (PDF) of the deviation"})
public class DeviationChartContinuousValue
extends AbstractDeviationChart
implements Visualization {
    @PostConstruct
    public void createVisualization(IContinuousValueDeviation dev, Composite parent) {
        Double upperBound;
        parent.setLayout((Layout)new GridLayout());
        FXCanvas canvas = new FXCanvas(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)canvas);
        BorderPane layout = new BorderPane();
        layout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
        Scene scene = new Scene((Parent)layout);
        canvas.setScene(scene);
        if (!this.isValid(dev)) {
            Label output = new Label();
            output.setText("Invalid input");
            layout.setCenter((Node)output);
            return;
        }
        Double lowerBound = dev.getLowerBound();
        if (this.isSinglePeek(lowerBound, upperBound = dev.getUpperBound())) {
            AreaChart<Number, Number> chart = this.createChart((EObject)dev, null);
            this.setChartXBounds(chart, lowerBound - 5.0, upperBound + 5.0);
            this.setChartYBounds(chart, 100.0);
            this.addSinglePeek(chart, 80.0, lowerBound);
            layout.setCenter(chart);
            return;
        }
        AreaChart<Number, Number> chart = this.createChart((EObject)dev, null);
        if (lowerBound != null && upperBound != null && lowerBound < upperBound) {
            double margin = 0.25 * (upperBound - lowerBound);
            double xMin = lowerBound - margin;
            double xMax = upperBound + margin;
            this.setChartXBounds(chart, xMin, xMax);
        }
        if (dev instanceof ContinuousValueHistogram) {
            this.fillChart(chart, (ContinuousValueHistogram)dev);
        } else if (dev instanceof ContinuousValueGaussDistribution) {
            this.fillChart(chart, (ContinuousValueGaussDistribution)dev);
        } else if (dev instanceof ContinuousValueBoundaries) {
            this.fillChart(chart, (ContinuousValueBoundaries)dev);
        } else if (dev instanceof ContinuousValueStatistics) {
            this.fillChart(chart, (ContinuousValueStatistics)dev);
        } else if (dev instanceof ContinuousValueUniformDistribution) {
            this.fillChart(chart, (ContinuousValueUniformDistribution)dev);
        } else if (dev instanceof ContinuousValueBetaDistribution) {
            this.fillChart(chart, (ContinuousValueBetaDistribution)dev);
        } else if (dev instanceof ContinuousValueWeibullEstimatorsDistribution) {
            this.fillChart(chart, (ContinuousValueWeibullEstimatorsDistribution)dev);
        }
        layout.setCenter(chart);
    }

    private void fillChart(AreaChart<Number, Number> chart, ContinuousValueHistogram histogram) {
        long maxY = 0L;
        for (ContinuousValueHistogramEntry entry : histogram.getEntries()) {
            double lower = entry.getLowerBound();
            double upper = entry.getUpperBound();
            long occur = entry.getOccurrences();
            maxY = Math.max(occur, maxY);
            XYChart.Series series = new XYChart.Series();
            series.getData().add((Object)new XYChart.Data((Object)lower, (Object)0L));
            series.getData().add((Object)new XYChart.Data((Object)lower, (Object)occur));
            series.getData().add((Object)new XYChart.Data((Object)upper, (Object)occur));
            series.getData().add((Object)new XYChart.Data((Object)upper, (Object)0L));
            this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)series);
        }
        this.setChartYBounds(chart, (double)maxY * 1.2);
        this.addMarkers(chart, (double)maxY * 1.1, histogram.getLowerBound(), histogram.getAverage(), histogram.getUpperBound());
    }

    private void fillChart(AreaChart<Number, Number> chart, ContinuousValueGaussDistribution dev) {
        double maxY = 0.0;
        Double lowerBound = dev.getLowerBound();
        Double upperBound = dev.getUpperBound();
        Double average = dev.getAverage();
        double xMin = dev.getMean() - 4.0 * dev.getSd();
        double xMax = dev.getMean() + 4.0 * dev.getSd();
        if (lowerBound != null && upperBound != null && lowerBound < upperBound) {
            double margin = 0.25 * (upperBound - lowerBound);
            xMin = lowerBound - margin;
            xMax = upperBound + margin;
        } else {
            if (lowerBound != null) {
                xMin = lowerBound - dev.getSd();
            }
            if (upperBound != null) {
                xMax = upperBound + dev.getSd();
            }
        }
        double step = (xMax - xMin) / 200.0;
        NormalDistribution mathFunction = new NormalDistribution(null, dev.getMean(), dev.getSd());
        XYChart.Series seriesMain = new XYChart.Series();
        XYChart.Series seriesLeft = new XYChart.Series();
        XYChart.Series seriesRight = new XYChart.Series();
        double x = xMin;
        while (x <= xMax) {
            double y = mathFunction.density(x);
            maxY = Math.max(y, maxY);
            if (lowerBound != null && x < lowerBound) {
                seriesLeft.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            } else if (upperBound != null && x > upperBound) {
                seriesRight.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            } else {
                seriesMain.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
            }
            x += step;
        }
        this.addSeriesOffLimit(chart, (XYChart.Series<Number, Number>)seriesLeft);
        this.addSeriesOffLimit(chart, (XYChart.Series<Number, Number>)seriesRight);
        this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)seriesMain);
        this.setChartXBounds(chart, xMin, xMax);
        this.setChartYBounds(chart, maxY * 1.2);
        this.addMarkers(chart, maxY * 1.1, lowerBound, average, upperBound);
    }

    private void fillChart(AreaChart<Number, Number> chart, ContinuousValueBoundaries dev) {
        double lower = dev.getLowerBound();
        double upper = dev.getUpperBound();
        XYChart.Series series = new XYChart.Series();
        series.getData().add((Object)new XYChart.Data((Object)lower, (Object)60));
        series.getData().add((Object)new XYChart.Data((Object)upper, (Object)60));
        this.addSeriesGradient(chart, (XYChart.Series<Number, Number>)series);
        this.setChartYBounds(chart, 100.0);
        this.addMarkers(chart, 80.0, lower, null, upper);
    }

    private void fillChart(AreaChart<Number, Number> chart, ContinuousValueStatistics dev) {
        double maxY = 0.0;
        double lower = dev.getLowerBound();
        double upper = dev.getUpperBound();
        double average = dev.getAverage();
        if (lower < upper) {
            double y1 = 100.0 / (average - lower);
            double y2 = 100.0 / (upper - average);
            maxY = Math.max(y1, y2);
            XYChart.Series series1 = new XYChart.Series();
            series1.getData().add((Object)new XYChart.Data((Object)lower, (Object)y1));
            series1.getData().add((Object)new XYChart.Data((Object)average, (Object)y1));
            XYChart.Series series2 = new XYChart.Series();
            series2.getData().add((Object)new XYChart.Data((Object)average, (Object)y2));
            series2.getData().add((Object)new XYChart.Data((Object)upper, (Object)y2));
            this.addSeriesGradient(chart, (XYChart.Series<Number, Number>)series1);
            this.addSeriesGradient(chart, (XYChart.Series<Number, Number>)series2);
            this.setChartYBounds(chart, maxY * 1.2);
            this.addMarkers(chart, maxY * 1.1, lower, average, upper);
        }
    }

    private void fillChart(AreaChart<Number, Number> chart, ContinuousValueUniformDistribution dev) {
        double lower = dev.getLowerBound();
        double upper = dev.getUpperBound();
        XYChart.Series series = new XYChart.Series();
        series.getData().add((Object)new XYChart.Data((Object)lower, (Object)60));
        series.getData().add((Object)new XYChart.Data((Object)upper, (Object)60));
        this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)series);
        this.setChartYBounds(chart, 100.0);
        this.addMarkers(chart, 80.0, lower, null, upper);
    }

    private void fillChart(AreaChart<Number, Number> chart, ContinuousValueBetaDistribution dist) {
        double maxY = 0.0;
        double x1 = dist.getLowerBound();
        double x2 = dist.getUpperBound();
        double range = x2 - x1;
        if (range > 0.0) {
            BetaDistribution mathFunction = new BetaDistribution(null, dist.getAlpha(), dist.getBeta());
            XYChart.Series series = new XYChart.Series();
            double x = 0.005;
            while (x < 1.0) {
                double y = mathFunction.density(x);
                maxY = Math.max(y, maxY);
                series.getData().add((Object)new XYChart.Data((Object)(x1 + x * range), (Object)y));
                x += 0.005;
            }
            this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)series);
        }
        this.setChartYBounds(chart, maxY * 1.2);
        this.addMarkers(chart, maxY * 1.1, x1, dist.getAverage(), x2);
    }

    private void fillChart(AreaChart<Number, Number> chart, ContinuousValueWeibullEstimatorsDistribution dev) {
        double maxY = 0.0;
        double lower = dev.getLowerBound();
        double upper = dev.getUpperBound();
        double average = dev.getAverage();
        double remain = dev.getPRemainPromille();
        WeibullUtil.Parameters params = WeibullUtil.findParameters((double)lower, (double)average, (double)upper, (double)remain);
        double shape = params.shape;
        double scale = params.scale;
        if (lower < upper) {
            if (params.error == null) {
                WeibullDistribution mathFunction = new WeibullDistribution(null, shape, scale);
                XYChart.Series seriesMain = new XYChart.Series();
                XYChart.Series seriesRight = new XYChart.Series();
                double xMax = chart.getXAxis() instanceof NumberAxis ? ((ValueAxis)chart.getXAxis()).getUpperBound() : upper;
                double step = (xMax - lower) / 200.0;
                double x = lower;
                while (x <= xMax) {
                    double y = mathFunction.density(x - lower);
                    if (Double.isFinite(y)) {
                        maxY = Math.max(y, maxY);
                        if (x <= upper) {
                            seriesMain.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
                        } else {
                            seriesRight.getData().add((Object)new XYChart.Data((Object)x, (Object)y));
                        }
                    }
                    x += step;
                }
                this.addSeriesStandard(chart, (XYChart.Series<Number, Number>)seriesMain);
                this.addSeriesOffLimit(chart, (XYChart.Series<Number, Number>)seriesRight);
            } else {
                maxY = 100.0;
            }
            this.setChartYBounds(chart, maxY * 1.2);
            double computedAvg = WeibullUtil.computeAverage((double)shape, (double)scale, (double)lower, (Double)upper);
            XYChart.Series series2 = new XYChart.Series();
            chart.getData().add((Object)series2);
            series2.setName("avg");
            series2.getData().add((Object)new XYChart.Data((Object)computedAvg, (Object)0));
            series2.getData().add((Object)new XYChart.Data((Object)computedAvg, (Object)(maxY / 2.0)));
            series2.getNode().lookup(".chart-series-area-line").setStyle("-fx-stroke: rgba(5, 150, 5, 1.0); -fx-stroke-dash-array: 3;");
            ((XYChart.Data)series2.getData().get(1)).getNode().setVisible(false);
            this.setChartYBounds(chart, maxY * 1.2);
            this.addMarkers(chart, maxY * 1.1, lower, average, upper);
        }
    }
}

