/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualization.runnabledependency;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.visualization.runnabledependency.GraphvizGenerator;
import org.eclipse.app4mc.amalthea.visualization.runnabledependency.GraphvizGeneratorConfig;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.RowLayoutFactory;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Runnable Data Dependencies", "description=Runnable Label Access Visualization for Software Models"})
public class RunnableDependencyVisualization
implements Visualization {
    private static GraphvizGeneratorConfig config = new GraphvizGeneratorConfig();
    private GraphvizGenerator graphvizGenerator;
    private Browser browser;
    private String dotPath;
    private SWModel model;

    @PostConstruct
    public void createVisualization(SWModel model, Composite parent, @Preference(nodePath="net.sourceforge.plantuml.eclipse", value="graphvizPath") String dotPath, IEventBroker broker) {
        this.graphvizGenerator = new GraphvizGenerator(config, true, true);
        this.model = model;
        this.setDotPath(dotPath);
        Composite pane = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(pane);
        Composite buttonArea = new Composite(pane, 0);
        this.browser = new Browser(pane, 0);
        if (broker != null) {
            this.setupElementNavigation(broker);
        }
        this.addToggleButton(buttonArea, "Horizontal Layout", config::setHorizontalLayout, config.isHorizontalLayout());
        this.addToggleButton(buttonArea, "Show Labels", config::setShowLabels, config.isShowLabels());
        this.addToggleButton(buttonArea, "Show R/W dependencies", config::setShowLabelDependencies, config.isShowLabelDependencies());
        this.addToggleButton(buttonArea, "Show Control Flow", config::setShowCallDependencies, config.isShowCallDependencies());
        this.addToggleButton(buttonArea, "Show Tasks", config::setShowTasks, config.isShowTasks());
        this.addPushButton(buttonArea, "Export", () -> {
            FileDialog fd = new FileDialog(parent.getShell(), 8192);
            fd.setFilterNames(new String[]{"Scalable Vector Graphics (*.svg)", "Portable Document Format (*.pdf)", "Portable Network Graphics (*.png)", "all files (*.*)"});
            fd.setFilterExtensions(new String[]{"*.svg", "*.pdf", "*.png", "*.*"});
            String path = fd.open();
            if (path != null) {
                this.export(path);
            }
        });
        this.addPushButton(buttonArea, "+", () -> {
            boolean bl = this.browser.execute("svg=document.getElementsByTagName(\"svg\")[0]; svg.width.baseVal.value *=1.25; svg.height.baseVal.value *=1.25;");
        });
        this.addPushButton(buttonArea, "-", () -> {
            boolean bl = this.browser.execute("svg=document.getElementsByTagName(\"svg\")[0]; svg.width.baseVal.value /=1.25; svg.height.baseVal.value /=1.25;");
        });
        RowLayoutFactory.swtDefaults().applyTo(buttonArea);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.browser);
        this.visualize();
    }

    private void setDotPath(String dotPathFromPreferences) {
        if (dotPathFromPreferences != null && !dotPathFromPreferences.isEmpty()) {
            this.dotPath = dotPathFromPreferences;
            return;
        }
        String dotPath2 = System.getenv("GRAPHVIZ_DOT");
        if (dotPath2 != null && !dotPath2.isEmpty()) {
            this.dotPath = dotPath2;
            return;
        }
        this.dotPath = Platform.getOS().equals("win32") ? "dot.exe" : "dot";
    }

    private void setupElementNavigation(IEventBroker broker) {
        this.browser.addLocationListener(LocationListener.changingAdapter(c -> {
            c.doit = true;
            Object target = null;
            int idx = c.location.indexOf(35);
            if (idx >= 0) {
                target = this.graphvizGenerator.getObjectById(c.location.substring(idx + 1));
            }
            if (target != null) {
                HashMap<String, List<Object>> data = new HashMap<String, List<Object>>();
                data.put("modelElements", Collections.singletonList(target));
                broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
            }
        }));
    }

    private void addToggleButton(Composite parent, String text, final Consumer<Boolean> f, boolean initialSelected) {
        final Button btn = new Button(parent, 2);
        btn.setText(text);
        btn.setSelection(initialSelected);
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }

            public void widgetSelected(SelectionEvent evt) {
                f.accept(btn.getSelection());
                RunnableDependencyVisualization.this.visualize();
            }
        });
    }

    private void addPushButton(Composite parent, String text, final Runnable cmd) {
        Button btn = new Button(parent, 8);
        btn.setText(text);
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent evt) {
                this.widgetSelected(evt);
            }

            public void widgetSelected(SelectionEvent evt) {
                cmd.run();
            }
        });
    }

    private void visualize() {
        new Thread(() -> {
            String result;
            String dot = this.graphvizGenerator.createDot(this.model);
            try {
                result = this.runGraphviz(dot, "-Tsvg");
            }
            catch (IOException e) {
                result = this.prepareErrorMessage(e);
                Platform.getLog(RunnableDependencyVisualization.class).error(result, (Throwable)e);
            }
            if (result != null && !this.browser.isDisposed()) {
                String browserContent = result;
                this.browser.getDisplay().asyncExec(() -> {
                    if (!this.browser.isDisposed()) {
                        this.browser.setText(browserContent);
                    }
                });
            }
        }).start();
    }

    private String prepareErrorMessage(IOException e) {
        return "Error invoking Graphviz: \"" + e.getMessage() + "\". Make sure you have configured the path to the dot executable properly in the PlantUML preferences.";
    }

    private void export(String path) {
        Display display = Display.getCurrent();
        Shell shell = display != null ? display.getActiveShell() : null;
        new Thread(() -> {
            block12: {
                String ext = path.substring(path.lastIndexOf(46) + 1);
                String dot = new GraphvizGenerator(config, !"dot".equals(ext), false).createDot(this.model);
                try {
                    if ("dot".equals(ext)) {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (PrintWriter writer = new PrintWriter(path);){
                            writer.append(dot);
                            break block12;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    this.runGraphviz(dot, "-T" + ext, "-o", path);
                }
                catch (IOException e) {
                    String msg = this.prepareErrorMessage(e);
                    Platform.getLog(RunnableDependencyVisualization.class).error(msg, (Throwable)e);
                    MessageDialog.openError((Shell)shell, (String)"Error during export", (String)msg);
                }
            }
        }).start();
    }

    private String runGraphviz(String dot, String ... args) throws IOException {
        int len;
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add(this.dotPath);
        command.addAll(Arrays.asList(args));
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
        InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
        writer.append(dot);
        writer.close();
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) >= 0) {
            sb.append(buf, 0, len);
        }
        return sb.toString();
    }
}

