/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AbstractMemoryElement;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.AmaltheaIndex;
import org.eclipse.app4mc.amalthea.model.HwFeature;
import org.eclipse.app4mc.amalthea.model.HwFeatureCategory;
import org.eclipse.app4mc.amalthea.model.ISR;
import org.eclipse.app4mc.amalthea.model.ISRAllocation;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.MappingModel;
import org.eclipse.app4mc.amalthea.model.Memory;
import org.eclipse.app4mc.amalthea.model.MemoryMapping;
import org.eclipse.app4mc.amalthea.model.Process;
import org.eclipse.app4mc.amalthea.model.ProcessingUnit;
import org.eclipse.app4mc.amalthea.model.ProcessingUnitDefinition;
import org.eclipse.app4mc.amalthea.model.Scheduler;
import org.eclipse.app4mc.amalthea.model.SchedulerAllocation;
import org.eclipse.app4mc.amalthea.model.Task;
import org.eclipse.app4mc.amalthea.model.TaskAllocation;
import org.eclipse.app4mc.amalthea.model.TaskScheduler;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.annotation.NonNull;

public class DeploymentUtil {
    private DeploymentUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Set<Process> getProcessesMappedToCore(@NonNull ProcessingUnit core, @NonNull Amalthea model) {
        HashSet<Process> result = new HashSet<Process>();
        result.addAll(DeploymentUtil.getTasksMappedToCore(core, model));
        result.addAll(DeploymentUtil.getISRsMappedToCore(core, model));
        return result;
    }

    public static Set<Task> getTasksMappedToCore(@NonNull ProcessingUnit core, @NonNull Amalthea model) {
        HashSet<Task> tasks = new HashSet<Task>();
        MappingModel mappingModel = model.getMappingModel();
        if (mappingModel == null) {
            return tasks;
        }
        HashSet<TaskScheduler> schedulers = new HashSet<TaskScheduler>();
        for (SchedulerAllocation schedAlloc : mappingModel.getSchedulerAllocation()) {
            if (!(schedAlloc.getScheduler() instanceof TaskScheduler) || !schedAlloc.getResponsibility().contains((Object)core)) continue;
            schedulers.add((TaskScheduler)schedAlloc.getScheduler());
        }
        for (TaskAllocation taskAlloc : mappingModel.getTaskAllocation()) {
            if (!schedulers.contains(taskAlloc.getScheduler()) || !taskAlloc.getAffinity().isEmpty() && !taskAlloc.getAffinity().contains((Object)core)) continue;
            tasks.add(taskAlloc.getTask());
        }
        return tasks;
    }

    public static Set<ISR> getISRsMappedToCore(@NonNull ProcessingUnit core, @NonNull Amalthea model) {
        if (core == null || model.getSwModel() == null || model.getSwModel().getIsrs() == null || model.getMappingModel() == null || model.getMappingModel().getIsrAllocation() == null) {
            return null;
        }
        HashSet<ISR> result = new HashSet<ISR>();
        EList<ISRAllocation> isrAlloc = model.getMappingModel().getIsrAllocation();
        EList<SchedulerAllocation> schedulerAllocs = model.getMappingModel().getSchedulerAllocation();
        for (ISR isr : model.getSwModel().getIsrs()) {
            for (ISRAllocation ia : isrAlloc) {
                if (ia.getIsr() == null || !ia.getIsr().equals(isr)) continue;
                for (SchedulerAllocation coreAlloc : schedulerAllocs) {
                    if (!coreAlloc.getResponsibility().contains((Object)core) || coreAlloc.getScheduler() != ia.getController()) continue;
                    result.add(isr);
                }
            }
        }
        return result;
    }

    public static List<TaskAllocation> getTaskAllocations(@NonNull Task task, @NonNull Amalthea model) {
        ArrayList<TaskAllocation> allocs = new ArrayList<TaskAllocation>();
        for (TaskAllocation ta : model.getMappingModel().getTaskAllocation()) {
            if (ta.getTask() == null || !ta.getTask().equals(task)) continue;
            allocs.add(ta);
        }
        return allocs;
    }

    public static Set<TaskAllocation> getTaskAllocations(@NonNull Task task) {
        return AmaltheaIndex.getReferringObjects(task, TaskAllocation.class);
    }

    public static Set<ISRAllocation> getIsrAllocations(@NonNull Process isr) {
        return AmaltheaIndex.getReferringObjects(isr, ISRAllocation.class);
    }

    public static boolean isMapped(@NonNull AbstractMemoryElement element) {
        return !DeploymentUtil.getMapping(element).isEmpty();
    }

    public static Set<Memory> getMapping(@NonNull AbstractMemoryElement element) {
        return element.getMappings().stream().map(MemoryMapping::getMemory).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static Set<Memory> getLabelMapping(@NonNull Label label) {
        return DeploymentUtil.getMapping(label);
    }

    public static MemoryMapping setMapping(@NonNull AbstractMemoryElement element, @NonNull Memory mem, @NonNull Amalthea model) {
        if (mem == null || element == null) {
            return null;
        }
        MemoryMapping mapping = AmaltheaFactory.eINSTANCE.createMemoryMapping();
        mapping.setAbstractElement(element);
        mapping.setMemory(mem);
        ModelUtil.getOrCreateMappingModel(model).getMemoryMapping().add((Object)mapping);
        return mapping;
    }

    public static MemoryMapping setLabelMapping(@NonNull Label label, @NonNull Memory mem, @NonNull Amalthea model) {
        return DeploymentUtil.setMapping(label, mem, model);
    }

    @Deprecated
    public static Set<ProcessingUnit> getAssignedCoreForProcess(Process process, Amalthea model) {
        if (model == null || process == null) {
            return null;
        }
        MappingModel mappingModel = model.getMappingModel();
        if (mappingModel == null) {
            return null;
        }
        HashSet<ProcessingUnit> processingUnits = new HashSet<ProcessingUnit>();
        if (process instanceof Task) {
            DeploymentUtil.getAssignedCoresForTask((Task)process, mappingModel, processingUnits);
        }
        if (process instanceof ISR) {
            DeploymentUtil.getAssignedCoresForISR((ISR)process, mappingModel, processingUnits);
        }
        return processingUnits;
    }

    @Deprecated
    private static void getAssignedCoresForISR(ISR isr, MappingModel mappingModel, Set<ProcessingUnit> processingUnits) {
        for (ISRAllocation isrAlloc : mappingModel.getIsrAllocation()) {
            if (isrAlloc.getIsr() == null || !isrAlloc.getIsr().equals(isr)) continue;
            for (SchedulerAllocation coreAlloc : mappingModel.getSchedulerAllocation()) {
                if (coreAlloc.getScheduler() == null || !coreAlloc.getScheduler().equals(isrAlloc.getController())) continue;
                processingUnits.addAll((Collection<ProcessingUnit>)coreAlloc.getResponsibility());
            }
        }
    }

    @Deprecated
    private static void getAssignedCoresForTask(Task task, MappingModel mappingModel, Set<ProcessingUnit> processingUnits) {
        HashSet<TaskAllocation> taskAllocations = new HashSet<TaskAllocation>();
        for (TaskAllocation taskAlloc : mappingModel.getTaskAllocation()) {
            if (taskAlloc.getTask() == null || !taskAlloc.getTask().equals(task)) continue;
            taskAllocations.add(taskAlloc);
        }
        for (SchedulerAllocation schedAlloc : mappingModel.getSchedulerAllocation()) {
            if (!(schedAlloc.getScheduler() instanceof TaskScheduler)) continue;
            TaskScheduler scheduler1 = (TaskScheduler)schedAlloc.getScheduler();
            for (TaskAllocation taskAlloc : taskAllocations) {
                TaskScheduler scheduler2 = taskAlloc.getScheduler();
                if (scheduler1 == null || !scheduler1.equals(scheduler2) && !scheduler1.getChildSchedulers().contains((Object)scheduler2)) continue;
                if (!taskAlloc.getAffinity().isEmpty()) {
                    for (ProcessingUnit core : taskAlloc.getAffinity()) {
                        if (!schedAlloc.getResponsibility().contains((Object)core)) continue;
                        processingUnits.add(core);
                    }
                    continue;
                }
                processingUnits.addAll((Collection<ProcessingUnit>)schedAlloc.getResponsibility());
            }
        }
    }

    public static Set<ProcessingUnit> getAssignedCoreForProcess(@NonNull Process process) {
        HashSet<ProcessingUnit> processingUnits = new HashSet<ProcessingUnit>();
        if (process instanceof Task) {
            DeploymentUtil.getAssignedCoresForTask((Task)process, processingUnits);
        }
        if (process instanceof ISR) {
            DeploymentUtil.getAssignedCoresForISR((ISR)process, processingUnits);
        }
        return processingUnits;
    }

    private static void getAssignedCoresForTask(@NonNull Task task, Set<ProcessingUnit> processingUnits) {
        HashSet schedulers = new HashSet();
        HashSet processingUnitsFromAffinity = new HashSet();
        AmaltheaIndex.getReferringObjects(task, TaskAllocation.class).stream().forEach(ta -> {
            schedulers.add(ta.getScheduler());
            processingUnitsFromAffinity.addAll(ta.getAffinity());
        });
        for (Scheduler scheduler : schedulers) {
            if (scheduler == null) continue;
            AmaltheaIndex.getReferringObjects(scheduler, SchedulerAllocation.class).stream().forEach(schedulerAllocation -> {
                boolean bl = processingUnits.addAll((Collection<ProcessingUnit>)schedulerAllocation.getResponsibility());
            });
        }
        if (!processingUnitsFromAffinity.isEmpty()) {
            processingUnits.removeIf(pu -> !processingUnitsFromAffinity.contains(pu));
        }
    }

    private static void getAssignedCoresForISR(@NonNull ISR isr, Set<ProcessingUnit> processingUnits) {
        HashSet controllers = new HashSet();
        AmaltheaIndex.getReferringObjects(isr, ISRAllocation.class).stream().forEach(isrAllocation -> {
            boolean bl = controllers.add(isrAllocation.getController());
        });
        for (Scheduler controller : controllers) {
            if (controller == null) continue;
            AmaltheaIndex.getReferringObjects(controller, SchedulerAllocation.class).stream().forEach(sa -> {
                boolean bl = processingUnits.addAll((Collection<ProcessingUnit>)sa.getResponsibility());
            });
        }
    }

    public static List<HwFeatureCategory> getFeatureCategories(ProcessingUnitDefinition procUnitDef) {
        ArrayList<HwFeatureCategory> result = new ArrayList<HwFeatureCategory>();
        for (HwFeature feature : procUnitDef.getFeatures()) {
            if (result.contains(feature.getContainingCategory())) continue;
            result.add(feature.getContainingCategory());
        }
        return result;
    }

    public static List<ProcessingUnitDefinition> getProcessingUnitDefinitionsForHwCategories(HwFeatureCategory hwFeatureCat, List<ProcessingUnitDefinition> procUnitDefinitons) {
        ArrayList<ProcessingUnitDefinition> result = new ArrayList<ProcessingUnitDefinition>();
        for (ProcessingUnitDefinition procUnitDef : procUnitDefinitons) {
            for (HwFeature feature : hwFeatureCat.getFeatures()) {
                if (!procUnitDef.getFeatures().contains((Object)feature)) continue;
                result.add(procUnitDef);
            }
        }
        return result;
    }

    public static List<ProcessingUnitDefinition> getProcessingUnitDefinitionsForHwFeature(HwFeature feature, List<ProcessingUnitDefinition> procUnitDefinitons) {
        ArrayList<ProcessingUnitDefinition> result = new ArrayList<ProcessingUnitDefinition>();
        for (ProcessingUnitDefinition procUnitDef : procUnitDefinitons) {
            if (!procUnitDef.getFeatures().contains((Object)feature)) continue;
            result.add(procUnitDef);
        }
        return result;
    }
}

