/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.svg;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;

public abstract class AbstractConfig {
    private static final String SCALE_KEY = "Scale";
    private static final String SCALE_DEFAULT = "100";
    private final PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected final VisualizationParameters parameters;

    protected AbstractConfig(VisualizationParameters viewParameters) {
        this.parameters = viewParameters;
    }

    public int getScale() {
        return Integer.parseInt(this.parameters.getOrDefault((Object)SCALE_KEY, SCALE_DEFAULT));
    }

    public boolean setScale(int newScale) {
        int oldScale = this.getScale();
        if (oldScale == newScale || newScale < 10 || newScale > 200) {
            return false;
        }
        this.parameters.put(SCALE_KEY, Integer.toString(newScale));
        this.firePropertyChange("scale", oldScale, newScale);
        return true;
    }

    public boolean decrementScale() {
        return this.setScale(Math.max(10, this.getScale() - 10));
    }

    public boolean incrementScale() {
        return this.setScale(Math.min(200, this.getScale() + 10));
    }

    public void addChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removeChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }
}

