/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.svg;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.app4mc.amalthea.model.AbstractEventChain;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventChainItem;
import org.eclipse.app4mc.amalthea.model.EventChainItemType;
import org.eclipse.app4mc.amalthea.model.EventChainReference;
import org.eclipse.app4mc.amalthea.model.SubEventChain;
import org.eclipse.app4mc.amalthea.visualizations.svg.Context;
import org.eclipse.app4mc.amalthea.visualizations.svg.EventChainMapConfig;
import org.eclipse.app4mc.visualization.util.svg.PlantUmlDiagram;
import org.eclipse.emf.ecore.EObject;

public class EventChainMapGenerator {
    private static final String REF_ICON = "<&link-intact> ";
    private static final String STIMULUS_ICON = "<&account-login> ";
    private static final String RESPONSE_ICON = "<&account-logout> ";

    private EventChainMapGenerator() {
        throw new IllegalStateException("Utility class");
    }

    public static void updateDiagram(Context context) {
        LocalContext lc = EventChainMapGenerator.createLocalContext(context);
        if (lc == null) {
            return;
        }
        lc.diagram.resetDiagramData();
        lc.diagram.append("' Created by EventChainMapGenerator (" + EventChainMapGenerator.timestamp() + ")\n\n");
        EventChainMapGenerator.buildContent(lc);
    }

    private static void buildContent(LocalContext lc) {
        lc.diagram.append("' ===== Event chain (as PlantUML mind map) =====\n\n");
        lc.diagram.append("@startmindmap\n\n");
        EventChainMapGenerator.createChain(lc, null, lc.chain, "+");
        lc.diagram.append("\n@endmindmap");
    }

    private static void createChain(LocalContext lc, EventChainItem chainItem, AbstractEventChain chain, String prefix) {
        boolean showEvents;
        if (chain == null) {
            return;
        }
        AbstractEventChain parent = lc.predecessors.isEmpty() ? null : lc.predecessors.get(0);
        String chainName = EventChainMapGenerator.getChainName(chain);
        String chainType = EventChainMapGenerator.getChainType(chain);
        String chainLink = EventChainMapGenerator.getLinkToObject((EObject)chain, lc);
        String chainIcon = chainItem instanceof EventChainReference ? REF_ICON : "";
        lc.diagram.append(String.valueOf(prefix) + " " + chainIcon + chainName + chainType + chainLink + "\n");
        String nextPrefix = String.valueOf(prefix) + "+";
        boolean isRecursive = lc.predecessors.contains(chain);
        boolean showItems = !(chainItem instanceof EventChainReference) || lc.config.isExpandSubchainReferences() && !isRecursive;
        boolean bl = showEvents = lc.config.isShowAllEvents() || !showItems || chain.getItems().isEmpty();
        if (showEvents) {
            Event stimulus = chain.getStimulus();
            Object stimulusName = EventChainMapGenerator.getEventName(stimulus, parent, chainItem, EventType.STIMULUS);
            String stimulusLink = EventChainMapGenerator.getLinkToObject((EObject)stimulus, lc);
            if (lc.config.isShowRepeatingEventsGrayed()) {
                stimulusName = EventChainMapGenerator.updateEventName((String)stimulusName, stimulus, lc.previousEvents);
            }
            lc.diagram.append(String.valueOf(nextPrefix) + "_ " + STIMULUS_ICON + (String)stimulusName + stimulusLink + "\n");
        }
        if (showItems) {
            lc.predecessors.add(0, chain);
            for (EventChainItem item : chain.getItems()) {
                EventChainMapGenerator.createChain(lc, item, item.getEventChain(), nextPrefix);
            }
            lc.predecessors.remove(0);
        }
        if (isRecursive) {
            lc.diagram.append(String.valueOf(nextPrefix) + "_ ...\n");
        }
        if (showEvents) {
            Event response = chain.getResponse();
            String responseName = EventChainMapGenerator.getEventName(response, parent, chainItem, EventType.RESPONSE);
            String responseLink = EventChainMapGenerator.getLinkToObject((EObject)response, lc);
            if (lc.config.isShowRepeatingEventsGrayed()) {
                responseName = EventChainMapGenerator.updateEventName(responseName, response, lc.previousEvents);
            }
            lc.diagram.append(String.valueOf(nextPrefix) + "_ " + RESPONSE_ICON + responseName + responseLink + "\n");
        }
    }

    private static String getLinkToObject(EObject eObj, LocalContext lc) {
        if (eObj == null || lc.diagram == null || !lc.config.isShowLinks()) {
            return "";
        }
        String id = lc.diagram.getOrCreateId((Object)eObj);
        return " [[#" + id + " link]]";
    }

    private static String getChainName(AbstractEventChain chain) {
        boolean isUndefined;
        if (chain == null) {
            return null;
        }
        String name = chain.getName();
        boolean bl = isUndefined = name == null || name.isEmpty();
        if (chain instanceof SubEventChain) {
            return isUndefined ? "_" : name;
        }
        return "<u>" + (isUndefined ? "<color:red><b>???</b></color>" : name) + "</u>";
    }

    private static String getChainType(AbstractEventChain chain) {
        if (chain == null) {
            return null;
        }
        if (chain.getItemType() == EventChainItemType.PARALLEL) {
            int max = chain.getItems().size();
            int min = chain.getMinItemsCompleted();
            if (max < 2) {
                return "";
            }
            if (min < 1 || min > max) {
                return " <i>(<color:red>???</color>)</i>";
            }
            if (min == 1) {
                return " <i>(alternative)</i>";
            }
            if (min < max) {
                return " <i>(" + min + " of " + max + ")</i>";
            }
            return " <i>(fork-join)</i>";
        }
        return "";
    }

    private static String getEventName(Event event, AbstractEventChain parent, EventChainItem chainItem, EventType type) {
        if (event == null || event.getName() == null || event.getName().isEmpty()) {
            return "<color:red><b>???</b></color>";
        }
        if (EventChainMapGenerator.isConsistent(parent, chainItem, type)) {
            return event.getName();
        }
        return "<color:red><b>" + event.getName() + "</b></color>";
    }

    private static String updateEventName(String eventName, Event event, List<Event> previousEvents) {
        Event previous;
        Event event2 = previous = previousEvents.isEmpty() ? null : previousEvents.get(previousEvents.size() - 1);
        if (event == previous) {
            return eventName.contains("<color:red>") ? eventName.replace("<color:red>", "<color:lightGray>") : "<color:lightGray>" + eventName + "</color>";
        }
        previousEvents.add(event);
        return eventName;
    }

    private static boolean isConsistent(AbstractEventChain parent, EventChainItem chainItem, EventType type) {
        boolean isStimulus;
        if (parent == null) {
            return true;
        }
        AbstractEventChain chain = chainItem.getEventChain();
        if (chain == null) {
            return false;
        }
        boolean isParallel = parent.getItemType() == EventChainItemType.PARALLEL;
        boolean bl = isStimulus = type == EventType.STIMULUS;
        if (isParallel) {
            return isStimulus ? chain.getStimulus() == parent.getStimulus() : chain.getResponse() == parent.getResponse();
        }
        int index = parent.getItems().indexOf((Object)chainItem);
        if (index < 0) {
            return false;
        }
        if (isStimulus) {
            if (index == 0) {
                return chain.getStimulus() == parent.getStimulus();
            }
            AbstractEventChain previousChain = ((EventChainItem)parent.getItems().get(index - 1)).getEventChain();
            return previousChain != null && chain.getStimulus() == previousChain.getResponse();
        }
        if (index == parent.getItems().size() - 1) {
            return chain.getResponse() == parent.getResponse();
        }
        AbstractEventChain nextChain = ((EventChainItem)parent.getItems().get(index + 1)).getEventChain();
        return nextChain != null && chain.getResponse() == nextChain.getStimulus();
    }

    static String timestamp() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        return dateFormat.format(new Date());
    }

    private static LocalContext createLocalContext(Context context) {
        if (context.object instanceof AbstractEventChain && context.config instanceof EventChainMapConfig && context.diagram instanceof PlantUmlDiagram) {
            return new LocalContext((AbstractEventChain)context.object, (EventChainMapConfig)context.config, (PlantUmlDiagram)context.diagram);
        }
        return null;
    }

    private static enum EventType {
        STIMULUS,
        RESPONSE;

    }

    private static class LocalContext {
        public final AbstractEventChain chain;
        public final EventChainMapConfig config;
        public final PlantUmlDiagram diagram;
        public final List<AbstractEventChain> predecessors = new ArrayList<AbstractEventChain>();
        public final List<Event> previousEvents = new ArrayList<Event>();

        public LocalContext(AbstractEventChain chain, EventChainMapConfig config, PlantUmlDiagram diagram) {
            this.chain = chain;
            this.config = config;
            this.diagram = diagram;
        }
    }
}

