/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb._import.amalthea.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.app4mc.atdb._import.amalthea.ImportTransformation;
import org.eclipse.app4mc.atdb._import.amalthea.handler.AMXMI2ATDBImport;
import org.eclipse.app4mc.atdb._import.amalthea.wizard.ImportPage;
import org.eclipse.app4mc.atdb._import.amalthea.wizard.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.osgi.framework.FrameworkUtil;

public class ImportWizard
extends Wizard
implements IImportWizard {
    private ImportPage mainPage;
    private IStructuredSelection selection;

    public void addPages() {
        super.addPages();
        this.mainPage = new ImportPage(this.selection);
        this.addPage((IWizardPage)this.mainPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)selection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.setWindowTitle(Messages.ImportWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        String amxmiSource = this.mainPage.getAMXMISource();
        String atdbSource = this.mainPage.getATDBSource();
        int from = Math.max(amxmiSource.lastIndexOf(47), amxmiSource.lastIndexOf(92));
        int to = amxmiSource.lastIndexOf(".amxmi");
        String name = amxmiSource.substring(from + 1, to);
        IFile targetATDB = this.mainPage.getTargetContainer().getFile(this.mainPage.getTargetContainer().getLocation().append(name).addFileExtension("atdb"));
        return ImportWizard.importAndOpenInIDE(amxmiSource, atdbSource, targetATDB, this.mainPage.isUpdateExistingATDB(), (IRunnableContext)this.getContainer());
    }

    public static boolean importAndOpenInIDE(final String amxmiSource, final String atdbSource, final IFile atdbTarget, final boolean copySource, IRunnableContext runnableContext) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException, CoreException {
                ImportTransformation transformer = new ImportTransformation(amxmiSource, atdbSource, atdbTarget.getLocation().toString(), copySource);
                transformer.run(progressMonitor);
                atdbTarget.refreshLocal(1, progressMonitor);
                progressMonitor.done();
            }
        };
        try {
            runnableContext.run(true, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e1) {
            Platform.getLog(AMXMI2ATDBImport.class).log((IStatus)new Status(4, FrameworkUtil.getBundle(AMXMI2ATDBImport.class).getSymbolicName(), e1.getLocalizedMessage(), (Throwable)e1));
            return false;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            IDE.openEditor((IWorkbenchPage)page, (IFile)atdbTarget);
        }
        catch (PartInitException e) {
            Platform.getLog(AMXMI2ATDBImport.class).log((IStatus)new Status(4, FrameworkUtil.getBundle(AMXMI2ATDBImport.class).getSymbolicName(), e.getLocalizedMessage(), (Throwable)e));
            return false;
        }
        return true;
    }
}

