/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.javafx.util;

import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.Activation;
import org.eclipse.app4mc.amalthea.model.AmaltheaFactory;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RunnableFilterDialog
extends Dialog {
    private static final String STATISTICS_MSG = "Currently selected {0} of {1}";
    private List<Runnable> originalList;
    private List<Runnable> result;
    private String nameFilter = "";
    private Activation activationFilter = null;
    private Activation emptyActivation;

    public RunnableFilterDialog(Shell parentShell, List<Runnable> toFilter) {
        super(parentShell);
        this.originalList = toFilter;
        this.result = toFilter;
        this.emptyActivation = AmaltheaFactory.eINSTANCE.createCustomActivation();
        this.emptyActivation.setName("---");
        this.activationFilter = this.emptyActivation;
    }

    private void filterRunnable() {
        this.result = this.originalList.stream().filter(r -> r.getName().contains(this.nameFilter) && (this.activationFilter == null || this.activationFilter.equals(this.emptyActivation) || r.getActivations().contains((Object)this.activationFilter))).collect(Collectors.toList());
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        Label hint = new Label(container, 0);
        hint.setText("The number of Runnables to visualize is greater than 100. The painting may take very long or even fail at all.\n\nPlease try to reduce the number of Runnables by applying a filter.");
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)hint);
        Label statistics = new Label(container, 0);
        statistics.setText(MessageFormat.format(STATISTICS_MSG, this.result.size(), this.originalList.size()));
        GridDataFactory.swtDefaults().align(4, 1).span(2, 1).grab(true, false).applyTo((Control)statistics);
        Label name = new Label(container, 0);
        name.setText("Name filter:");
        GridDataFactory.swtDefaults().align(4, 1).grab(false, false).applyTo((Control)name);
        Text nameFilterText = new Text(container, 2048);
        nameFilterText.setText(this.nameFilter);
        nameFilterText.addModifyListener(e -> {
            this.nameFilter = nameFilterText.getText();
            this.filterRunnable();
            statistics.setText(MessageFormat.format(STATISTICS_MSG, this.result.size(), this.originalList.size()));
        });
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo((Control)nameFilterText);
        Label activation = new Label(container, 0);
        activation.setText("Activation filter:");
        GridDataFactory.swtDefaults().align(4, 1).grab(false, false).applyTo((Control)activation);
        ComboViewer activationFilterCombo = new ComboViewer(container, 8);
        activationFilterCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        activationFilterCombo.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            /*
             * WARNING - void declaration
             */
            public String getText(Object element) {
                Object object = element;
                if (object instanceof Activation) {
                    void activation;
                    Activation activation2 = (Activation)object;
                    Activation cfr_ignored_0 = (Activation)object;
                    return activation.getName();
                }
                return super.getText(element);
            }
        });
        List activations = this.originalList.stream().flatMap(r -> r.getActivations().stream()).distinct().collect(Collectors.toList());
        activations.add(0, this.emptyActivation);
        activationFilterCombo.setInput(activations);
        if (this.activationFilter != null) {
            activationFilterCombo.setSelection((ISelection)new StructuredSelection(List.of(this.activationFilter)));
        }
        GridDataFactory.swtDefaults().align(4, 4).grab(true, false).applyTo(activationFilterCombo.getControl());
        activationFilterCombo.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() > 0) {
                this.activationFilter = (Activation)selection.getFirstElement();
                this.filterRunnable();
                statistics.setText(MessageFormat.format(STATISTICS_MSG, this.result.size(), this.originalList.size()));
            }
        });
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Filter Runnables");
    }

    protected boolean isResizable() {
        return true;
    }

    public List<Runnable> getSelectedRunnables() {
        return this.result;
    }
}

