/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.DerivedDataSet;
import org.eclipse.birt.report.model.elements.interfaces.IDerivedDataSetModel;
import org.eclipse.birt.report.model.elements.interfaces.IDerivedExtendableElementModel;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class DerivedDataSetHandle
extends DataSetHandle
implements IDerivedDataSetModel,
IDerivedExtendableElementModel {
    public DerivedDataSetHandle(Module module, DerivedDataSet element) {
        super(module, element);
    }

    public void setQueryText(String text) throws SemanticException {
        this.setStringProperty("queryText", text);
    }

    public String getQueryText() {
        return this.getStringProperty("queryText");
    }

    public void addInputDataSets(String dataSetName) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("inputDataSets");
        if (propHandle != null) {
            propHandle.addItem(dataSetName);
        }
    }

    public void removeInputDataSet(String dataSetName) throws SemanticException {
        PropertyHandle propHandle = this.getPropertyHandle("inputDataSets");
        if (propHandle != null) {
            propHandle.removeItem(dataSetName);
        }
    }

    public List<DataSetHandle> getInputDataSets() {
        List<Object> dataSetRefs = this.getElement().getListProperty(this.getModule(), "inputDataSets");
        if (dataSetRefs == null || dataSetRefs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DataSetHandle> dataSets = new ArrayList<DataSetHandle>();
        int i = 0;
        while (i < dataSetRefs.size()) {
            ElementRefValue refValue = (ElementRefValue)dataSetRefs.get(i);
            if (refValue != null && refValue.getElement() != null) {
                DesignElement dataSet = refValue.getElement();
                dataSets.add((DataSetHandle)dataSet.getHandle(dataSet.getRoot()));
            }
            ++i;
        }
        return dataSets;
    }

    public String getExtensionID() {
        return this.getStringProperty("extensionID");
    }
}

