/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.impl.ColumnNameHelper;
import org.eclipse.birt.report.model.adapter.oda.impl.ModelOdaAdapter;
import org.eclipse.birt.report.model.adapter.oda.impl.NativeDataTypeUtil;
import org.eclipse.birt.report.model.api.AbstractScalarParameterHandle;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.datatools.connectivity.oda.design.CustomData;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DynamicValuesQuery;
import org.eclipse.datatools.connectivity.oda.design.ElementNullability;
import org.eclipse.datatools.connectivity.oda.design.InputPromptControlStyle;
import org.eclipse.datatools.connectivity.oda.design.ParameterMode;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueChoices;
import org.eclipse.datatools.connectivity.oda.design.ScalarValueDefinition;
import org.eclipse.datatools.connectivity.oda.design.StaticValues;
import org.eclipse.emf.common.util.EList;

public class AdapterUtil {
    private static ColumnNameHelper columnNameHelper = new ColumnNameHelper();

    static ParameterMode newParameterMode(boolean isInput, boolean isOutput) {
        int mode = 0;
        if (isOutput && isInput) {
            mode = 2;
        } else if (isOutput) {
            mode = 1;
        } else if (isInput) {
            mode = 0;
        }
        return ParameterMode.get((int)mode);
    }

    static Boolean getROMNullability(ElementNullability nullability) {
        if (nullability == null) {
            return null;
        }
        switch (nullability.getValue()) {
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 0: {
                return null;
            }
        }
        return null;
    }

    static InputPromptControlStyle newPromptStyle(String controlType, boolean mustMatch) {
        if (controlType == null) {
            return null;
        }
        int type = -1;
        if ("check-box".equalsIgnoreCase(controlType)) {
            type = 3;
        } else if ("list-box".equalsIgnoreCase(controlType)) {
            type = mustMatch ? 1 : 2;
        } else if ("radio-button".equalsIgnoreCase(controlType)) {
            type = 4;
        } else if ("text-box".equalsIgnoreCase(controlType)) {
            type = 0;
        }
        return InputPromptControlStyle.get((int)type);
    }

    static String newROMControlType(InputPromptControlStyle style) {
        if (style == null) {
            return null;
        }
        switch (style.getValue()) {
            case 3: {
                return "check-box";
            }
            case 1: 
            case 2: {
                return "list-box";
            }
            case 4: {
                return "radio-button";
            }
            case 0: {
                return "text-box";
            }
        }
        return null;
    }

    static boolean needsQuoteDelimiters(String romDataType) {
        boolean needs = false;
        if ("string".equals(romDataType)) {
            needs = true;
        } else if ("dateTime".equals(romDataType)) {
            needs = true;
        } else if ("date".equals(romDataType)) {
            needs = true;
        } else if ("time".equals(romDataType)) {
            needs = true;
        } else if ("any".equals(romDataType)) {
            needs = true;
        }
        return needs;
    }

    static void updateROMDefaultValues(StaticValues defaultValues, AbstractScalarParameterHandle reportParam) throws SemanticException {
        if (defaultValues == null || reportParam == null) {
            return;
        }
        ArrayList<Expression> newValues = null;
        if (defaultValues != null && !defaultValues.isEmpty()) {
            newValues = new ArrayList<Expression>();
            for (Object tmpValue : defaultValues.getValues()) {
                newValues.add(AdapterUtil.createExpression(tmpValue));
            }
        }
        reportParam.setDefaultValueList(newValues);
    }

    static void updateROMSelectionList(ScalarValueChoices staticChoices, ScalarValueChoices cachedChoices, AbstractScalarParameterHandle paramHandle) throws SemanticException {
        if (staticChoices == null || paramHandle == null) {
            return;
        }
        ArrayList<SelectionChoice> retList = new ArrayList<SelectionChoice>();
        EList choiceList = staticChoices.getScalarValues();
        EList cachedChoiceList = null;
        if (cachedChoices != null) {
            cachedChoiceList = cachedChoices.getScalarValues();
        }
        boolean useCached = false;
        if (cachedChoiceList != null && choiceList.size() == cachedChoiceList.size()) {
            useCached = true;
        }
        int i = 0;
        while (i < choiceList.size()) {
            ScalarValueDefinition valueDefn = (ScalarValueDefinition)choiceList.get(i);
            SelectionChoice choice = StructureFactory.createSelectionChoice();
            choice.setValue(valueDefn.getValue());
            String label = valueDefn.getDisplayName();
            String labelKey = valueDefn.getDisplayNameKey();
            if (label != null || labelKey != null) {
                choice.setLabel(label);
                choice.setLabelResourceKey(labelKey);
            } else if (useCached) {
                valueDefn = (ScalarValueDefinition)cachedChoiceList.get(i);
                label = valueDefn.getDisplayName();
                labelKey = valueDefn.getDisplayNameKey();
                if (label != null || labelKey != null) {
                    choice.setLabel(label);
                    choice.setLabelResourceKey(labelKey);
                }
            }
            retList.add(choice);
            ++i;
        }
        PropertyHandle propHandle = paramHandle.getPropertyHandle("selectionList");
        propHandle.clearValue();
        int i2 = 0;
        while (i2 < retList.size()) {
            propHandle.addItem(retList.get(i2));
            ++i2;
        }
    }

    static void updateROMDyanmicList(DynamicValuesQuery valueQuery, DynamicValuesQuery cachedValueQuery, AbstractScalarParameterHandle reportParam, OdaDataSetHandle setHandle) throws SemanticException {
        ExpressionHandle exprHandle;
        if (valueQuery == null) {
            return;
        }
        String value = valueQuery.getDataSetDesign().getName();
        String cachedValue = null;
        DataSetDesign dataSetDesign = null;
        if (cachedValueQuery != null) {
            dataSetDesign = cachedValueQuery.getDataSetDesign();
        }
        if (dataSetDesign != null) {
            cachedValue = dataSetDesign.getName();
        }
        if (cachedValue == null || !cachedValue.equals(value)) {
            reportParam.setDataSetName(value);
            ModuleHandle module = setHandle.getModuleHandle();
            DataSetHandle target = module.findDataSet(value);
            if (target instanceof OdaDataSetHandle && target != setHandle) {
                new ModelOdaAdapter().updateLinkedParameterDataSetHandle(valueQuery.getDataSetDesign(), (OdaDataSetHandle)target, false, setHandle.getDataSource());
            }
            if (target == null) {
                OdaDataSetHandle nestedDataSet = new ModelOdaAdapter().createLinkedParameterDataSetHandle(valueQuery.getDataSetDesign(), module, setHandle.getDataSource());
                module.getDataSets().add((DesignElementHandle)nestedDataSet);
            }
        }
        value = valueQuery.getValueColumn();
        String string = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getValueColumn();
        if (cachedValue == null || !cachedValue.equals(value)) {
            exprHandle = reportParam.getExpressionProperty("valueExpr");
            exprHandle.setExpression((Object)columnNameHelper.createColumnExpression(value, exprHandle.getType()));
        }
        value = valueQuery.getDisplayNameColumn();
        String string2 = cachedValue = cachedValueQuery == null ? null : cachedValueQuery.getDisplayNameColumn();
        if (cachedValue == null || !cachedValue.equals(value)) {
            exprHandle = reportParam.getExpressionProperty("labelExpr");
            exprHandle.setExpression((Object)columnNameHelper.createColumnExpression(value, exprHandle.getType()));
        }
    }

    static String convertNativeTypeToROMDataType(String dataSourceId, String dataSetId, int nativeDataTypeCode, String romDataType) {
        String newRomDataType = null;
        try {
            newRomDataType = NativeDataTypeUtil.getUpdatedDataType(dataSourceId, dataSetId, nativeDataTypeCode, romDataType, "columnDataType");
        }
        catch (BirtException birtException) {
            // empty catch block
        }
        return newRomDataType;
    }

    static ColumnHintHandle findColumnHint(OdaResultSetColumn setColumn, Iterator columnHints) {
        assert (setColumn != null);
        return AdapterUtil.findColumnHint(setColumn.getColumnName(), columnHints);
    }

    /*
     * Unable to fully structure code
     */
    static ColumnHintHandle findColumnHint(String name, Iterator columnHints) {
        if (name != null) ** GOTO lbl6
        return null;
lbl-1000:
        // 1 sources

        {
            hint = (ColumnHintHandle)columnHints.next();
            if (!name.equals(hint.getColumnName())) continue;
            return hint;
lbl6:
            // 2 sources

            ** while (columnHints.hasNext())
        }
lbl7:
        // 1 sources

        return null;
    }

    static Expression createExpression(Object value) {
        CustomData customData;
        String exprType = null;
        if (value instanceof String) {
            if (StringUtil.isBlank((String)((String)value))) {
                exprType = "javascript";
                value = "\"" + value + "\"";
            } else {
                exprType = "constant";
            }
        }
        if (value instanceof CustomData && "org.eclipse.birt.report.model.adapter.oda".equals((customData = (CustomData)value).getProviderId()) && customData.getValue() != null) {
            exprType = "javascript";
            value = customData.getValue();
        }
        if (exprType != null) {
            return new Expression(value, exprType);
        }
        return null;
    }

    static boolean isNullExpression(Object value) {
        return value == null || value instanceof Expression && ((Expression)value).getExpression() == null;
    }

    static String extractColumnName(Object column) {
        return columnNameHelper.extractColumnName(column);
    }
}

