/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.script.internal;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.script.api.IChartWithoutAxes;
import org.eclipse.birt.chart.script.api.component.ICategory;
import org.eclipse.birt.chart.script.api.component.IValueSeries;
import org.eclipse.birt.chart.script.internal.ChartImpl;
import org.eclipse.birt.chart.script.internal.component.CategoryImpl;
import org.eclipse.birt.chart.script.internal.component.ValueSeriesImpl;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.emf.common.util.EList;

public class ChartWithoutAxesImpl
extends ChartImpl
implements IChartWithoutAxes {
    public ChartWithoutAxesImpl(ExtendedItemHandle eih, ChartWithoutAxes cm) {
        super(eih, (Chart)cm);
    }

    @Override
    public IValueSeries[] getValueSeries() {
        SeriesDefinition bsd = (SeriesDefinition)this.getChartWithoutAxes().getSeriesDefinitions().get(0);
        EList osds = bsd.getSeriesDefinitions();
        IValueSeries[] valueSeries = new IValueSeries[osds.size()];
        int i = 0;
        while (i < valueSeries.length) {
            SeriesDefinition osd = (SeriesDefinition)osds.get(i);
            valueSeries[i] = ValueSeriesImpl.createValueSeries(osd, this.cm);
            ++i;
        }
        return valueSeries;
    }

    @Override
    public ICategory getCategory() {
        SeriesDefinition bsd = (SeriesDefinition)this.getChartWithoutAxes().getSeriesDefinitions().get(0);
        return new CategoryImpl(bsd, this.cm);
    }

    private ChartWithoutAxes getChartWithoutAxes() {
        return (ChartWithoutAxes)this.cm;
    }

    @Override
    public void setDimension(String dimensionName) {
        if (ChartDimension.THREE_DIMENSIONAL_LITERAL.getName().equals(dimensionName)) {
            throw new IllegalArgumentException(Messages.getString("ChartWithoutAxesImpl.exception.3DNotSupported"));
        }
        super.setDimension(dimensionName);
    }
}

