/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.internal.ui.dialogs.AbstractFieldEditor;
import org.eclipse.birt.report.designer.internal.ui.dialogs.StylePreferenceStore;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.StyleBuilder;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class BaseStylePreferencePage
extends FieldEditorPreferencePage {
    protected Logger logger = Logger.getLogger(BaseStylePreferencePage.class.getName());
    private Label descriptionLabel;
    private Control body;
    private boolean createDefaultButton = true;
    private Button defaultsButton;
    private StyleBuilder builder;
    private boolean firstCheck = false;
    protected boolean hasLocaleProperty = false;
    private List fields;

    protected void createFieldEditors() {
        this.noDefaultButton();
    }

    protected void noDefaultButton() {
        this.createDefaultButton = false;
    }

    public void createControl(Composite parent) {
        Composite content = new Composite(parent, 0);
        this.setControl((Control)content);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        content.setLayout((Layout)layout);
        this.applyDialogFont(content);
        this.initializeDialogUnits((Control)content);
        this.descriptionLabel = this.createDescriptionLabel(content);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setLayoutData((Object)new GridData(768));
        }
        this.body = this.createContents(content);
        if (this.body != null) {
            this.body.setLayoutData((Object)new GridData(1808));
        }
        Composite buttonBar = new Composite(content, 0);
        layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.makeColumnsEqualWidth = false;
        buttonBar.setLayout((Layout)layout);
        GridData gd = new GridData(128);
        buttonBar.setLayoutData((Object)gd);
        this.contributeButtons(buttonBar);
        if (this.createDefaultButton) {
            ++layout.numColumns;
            String[] labels = JFaceResources.getStrings((String[])new String[]{"defaults", "apply"});
            int widthHint = this.convertHorizontalDLUsToPixels(61);
            this.defaultsButton = new Button(buttonBar, 8);
            this.defaultsButton.setText(labels[0]);
            Dialog.applyDialogFont((Control)this.defaultsButton);
            GridData data = new GridData(256);
            Point minButtonSize = this.defaultsButton.computeSize(-1, -1, true);
            data.widthHint = Math.max(widthHint, minButtonSize.x);
            this.defaultsButton.setLayoutData((Object)data);
            this.defaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BaseStylePreferencePage.this.performDefaults();
                }
            });
            this.applyDialogFont(buttonBar);
        } else if (buttonBar.getChildren().length < 1) {
            buttonBar.dispose();
        }
    }

    protected Point doComputeSize() {
        if (this.descriptionLabel != null && this.body != null) {
            Point bodySize = this.body.computeSize(-1, -1, true);
            GridData gd = (GridData)this.descriptionLabel.getLayoutData();
            gd.widthHint = bodySize.x;
        }
        return this.getControl().computeSize(-1, -1, true);
    }

    protected BaseStylePreferencePage(Object model) {
        super(1);
        this.setTitle(Messages.getString((String)"BaseStylePreferencePage.displayname.Title"));
        StylePreferenceStore store = new StylePreferenceStore(model);
        this.setPreferenceStore(store);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (this.getBuilder() != null) {
            this.getBuilder().refreshPagesStatus();
        }
    }

    public boolean performOk() {
        IPreferenceStore ps = this.getPreferenceStore();
        if (ps instanceof StylePreferenceStore) {
            ((StylePreferenceStore)ps).clearError();
        }
        boolean rt = super.performOk();
        if (ps instanceof StylePreferenceStore) {
            return !((StylePreferenceStore)ps).hasError();
        }
        return rt;
    }

    protected Button getDefaultsButton() {
        return this.defaultsButton;
    }

    public StyleBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(StyleBuilder builder) {
        this.builder = builder;
    }

    public void setErrorMessage(String newMessage) {
        if (this.builder != null) {
            this.builder.setErrorMessage(newMessage);
        } else {
            super.setErrorMessage(newMessage);
            if (this.getContainer() != null) {
                this.getContainer().updateMessage();
            }
        }
    }

    protected abstract String[] getPreferenceNames();

    public boolean hasLocaleProperties() {
        if (!this.firstCheck) {
            this.firstCheck = true;
            String[] fields = this.getPreferenceNames();
            if (fields != null) {
                int i = 0;
                while (i < fields.length) {
                    StylePreferenceStore store;
                    if (this.getPreferenceStore() instanceof StylePreferenceStore && (store = (StylePreferenceStore)this.getPreferenceStore()).hasLocalValue(fields[i])) {
                        this.hasLocaleProperty = true;
                        return true;
                    }
                    ++i;
                }
            }
        } else if (this.fields != null) {
            int i = 0;
            while (i < this.fields.size()) {
                FieldEditor editor = (FieldEditor)this.fields.get(i);
                if (editor instanceof AbstractFieldEditor && ((AbstractFieldEditor)editor).hasLocaleValue()) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return this.hasLocaleProperty;
    }

    protected void addField(FieldEditor editor) {
        if (this.fields == null) {
            this.fields = new ArrayList();
        }
        this.fields.add(editor);
        super.addField(editor);
    }
}

