/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.List;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.IRowResultSet;
import org.eclipse.birt.data.engine.executor.cache.OdiAdapter;
import org.eclipse.birt.data.engine.executor.cache.SmartCacheRequest;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.odi.IResultObjectEvent;

public class RowResultSet
implements IRowResultSet {
    private List eventList;
    private OdiAdapter odiAdpater;
    private IResultClass resultClass;
    private int maxRows;
    private int currIndex;
    private int actualIndex = -1;
    private boolean distinctValueFlag;
    private IResultObject lastResultObject;
    private IResultObject nextResultObject;
    private boolean finished = false;

    public RowResultSet(SmartCacheRequest smartCacheRequest) {
        this(smartCacheRequest, smartCacheRequest.getMaxRow());
    }

    public RowResultSet(SmartCacheRequest smartCacheRequest, int maxRow) {
        this.eventList = smartCacheRequest.getEventList();
        this.odiAdpater = smartCacheRequest.getOdiAdapter();
        this.resultClass = smartCacheRequest.getResultClass();
        this.maxRows = maxRow;
        if (this.maxRows <= 0) {
            this.maxRows = Integer.MAX_VALUE;
        }
        this.distinctValueFlag = smartCacheRequest.getDistinctValueFlag();
    }

    @Override
    public IResultClass getMetaData() {
        return this.resultClass;
    }

    @Override
    public IResultObject next() throws DataException {
        this.beforeNext();
        IResultObject result = this.doNext();
        this.afterNext();
        return result;
    }

    private IResultObject doNext() throws DataException {
        if (this.finished) {
            return null;
        }
        if (this.nextResultObject != null) {
            this.lastResultObject = this.nextResultObject;
            this.nextResultObject = null;
            return this.lastResultObject;
        }
        if (this.currIndex >= this.maxRows) {
            return null;
        }
        IResultObject odaObject = null;
        while ((odaObject = this.fetch()) != null) {
            ++this.actualIndex;
            if (!this.processFetchEvent(odaObject, this.actualIndex) || this.distinctValueFlag && this.isDuplicatedObject(odaObject)) continue;
            ++this.currIndex;
            break;
        }
        return odaObject;
    }

    protected IResultObject fetch() throws DataException {
        return this.odiAdpater.fetch();
    }

    private boolean processFetchEvent(IResultObject resultObject, int currentIndex) throws DataException {
        assert (resultObject != null);
        if (this.eventList != null) {
            this.beforeProcessFetchEvent(resultObject, currentIndex);
            try {
                int size = this.eventList.size();
                int i = 0;
                while (i < size) {
                    IResultObjectEvent onFetchEvent = (IResultObjectEvent)this.eventList.get(i);
                    if (!onFetchEvent.process(resultObject, currentIndex)) {
                        return false;
                    }
                    ++i;
                }
            }
            finally {
                this.afterProcessFetchEvent(resultObject, currentIndex);
            }
        }
        return true;
    }

    protected void beforeProcessFetchEvent(IResultObject resultObject, int currentIndex) throws DataException {
    }

    protected void afterProcessFetchEvent(IResultObject resultObject, int currentIndex) throws DataException {
    }

    private boolean isDuplicatedObject(IResultObject currRowObject) {
        if (currRowObject.equals(this.lastResultObject)) {
            return true;
        }
        this.lastResultObject = currRowObject;
        return false;
    }

    @Override
    public int getIndex() throws DataException {
        if (this.nextResultObject != null) {
            return this.currIndex - 2;
        }
        return this.currIndex - 1;
    }

    public IResultObject getNext() throws DataException {
        if (this.finished) {
            return null;
        }
        if (this.nextResultObject != null) {
            return this.nextResultObject;
        }
        this.nextResultObject = this.next();
        if (this.nextResultObject != null) {
            return this.nextResultObject;
        }
        this.finished = true;
        return null;
    }

    protected void beforeNext() throws DataException {
    }

    protected void afterNext() throws DataException {
    }
}

