/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.connection.client;

import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import me.prettyprint.cassandra.connection.client.HClient;
import me.prettyprint.cassandra.service.CassandraHost;
import me.prettyprint.cassandra.service.SystemProperties;
import me.prettyprint.hector.api.exceptions.HInvalidRequestException;
import me.prettyprint.hector.api.exceptions.HectorTransportException;
import org.apache.cassandra.thrift.Cassandra;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.commons.lang.StringUtils;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TSSLTransportFactory;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HThriftClient
implements HClient {
    private static Logger log = LoggerFactory.getLogger(HThriftClient.class);
    private static final String NAME_FORMAT = "CassandraClient<%s-%d>";
    private static final AtomicLong serial = new AtomicLong(0L);
    final CassandraHost cassandraHost;
    private final long mySerial;
    protected final int timeout;
    protected String keyspaceName;
    private long useageStartTime;
    protected TTransport transport;
    protected Cassandra.Client cassandraClient;
    private TSSLTransportFactory.TSSLTransportParameters params;
    private final Map<String, String> credentials = new HashMap<String, String>();

    public HThriftClient(CassandraHost cassandraHost) {
        this.cassandraHost = cassandraHost;
        this.timeout = this.getTimeout(cassandraHost);
        this.mySerial = serial.incrementAndGet();
    }

    public HThriftClient(CassandraHost cassandraHost, TSSLTransportFactory.TSSLTransportParameters params) {
        this.cassandraHost = cassandraHost;
        this.timeout = this.getTimeout(cassandraHost);
        this.params = params;
        this.mySerial = serial.incrementAndGet();
    }

    @Override
    public Cassandra.Client getCassandra() {
        if (!this.isOpen()) {
            throw new IllegalStateException("getCassandra called on client that was not open. You should not have gotten here.");
        }
        if (this.cassandraClient == null) {
            this.cassandraClient = new Cassandra.Client((TProtocol)new TBinaryProtocol(this.transport));
        }
        return this.cassandraClient;
    }

    @Override
    public Cassandra.Client getCassandra(String keyspaceNameArg) {
        this.getCassandra();
        if (keyspaceNameArg != null && !StringUtils.equals((String)this.keyspaceName, (String)keyspaceNameArg)) {
            if (log.isDebugEnabled()) {
                log.debug("keyspace reseting from {} to {}", (Object)this.keyspaceName, (Object)keyspaceNameArg);
            }
            try {
                this.cassandraClient.set_keyspace(keyspaceNameArg);
            }
            catch (InvalidRequestException ire) {
                throw new HInvalidRequestException(ire);
            }
            catch (TException e) {
                throw new HectorTransportException(e);
            }
            this.keyspaceName = keyspaceNameArg;
        }
        return this.cassandraClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HThriftClient close() {
        if (log.isDebugEnabled()) {
            log.debug("Closing client {}", (Object)this);
        }
        if (this.isOpen()) {
            try {
                this.transport.flush();
            }
            catch (Exception e) {
                log.error("Could not flush transport (to be expected if the pool is shutting down) in close for client: " + this.toString(), (Throwable)e);
            }
            finally {
                try {
                    this.transport.close();
                }
                catch (Exception e) {
                    log.error("Error on transport close for client: " + this.toString(), (Throwable)e);
                }
            }
        }
        return this;
    }

    @Override
    public HThriftClient open() {
        TSocket socket;
        if (this.isOpen()) {
            throw new IllegalStateException("Open called on already open connection. You should not have gotten here.");
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating a new thrift connection to {}", (Object)this.cassandraHost);
        }
        try {
            socket = this.params == null ? new TSocket(this.cassandraHost.getHost(), this.cassandraHost.getPort(), this.timeout) : TSSLTransportFactory.getClientSocket((String)this.cassandraHost.getHost(), (int)this.cassandraHost.getPort(), (int)this.timeout, (TSSLTransportFactory.TSSLTransportParameters)this.params);
        }
        catch (TTransportException e) {
            throw new HectorTransportException("Could not get client socket: ", e);
        }
        if (this.cassandraHost.getUseSocketKeepalive()) {
            try {
                socket.getSocket().setKeepAlive(true);
            }
            catch (SocketException se) {
                throw new HectorTransportException("Could not set SO_KEEPALIVE on socket: ", se);
            }
        }
        this.transport = this.cassandraHost.getUseThriftFramedTransport() ? new TFramedTransport((TTransport)socket) : socket;
        try {
            this.transport.open();
        }
        catch (TTransportException e) {
            log.debug("Unable to open transport to " + this.cassandraHost.getName());
            throw new HectorTransportException("Unable to open transport to " + this.cassandraHost.getName() + " , " + e.getLocalizedMessage(), e);
        }
        return this;
    }

    @Override
    public boolean isOpen() {
        boolean open = false;
        if (this.transport != null) {
            open = this.transport.isOpen();
        }
        if (log.isTraceEnabled()) {
            log.trace("Transport open status {} for client {}", (Object)open, (Object)this);
        }
        return open;
    }

    private int getTimeout(CassandraHost cassandraHost) {
        int timeoutVar = 0;
        if (cassandraHost != null && cassandraHost.getCassandraThriftSocketTimeout() > 0) {
            timeoutVar = cassandraHost.getCassandraThriftSocketTimeout();
        } else {
            String timeoutStr = System.getProperty(SystemProperties.CASSANDRA_THRIFT_SOCKET_TIMEOUT.toString());
            if (timeoutStr != null && timeoutStr.length() > 0) {
                try {
                    timeoutVar = Integer.parseInt(timeoutStr);
                }
                catch (NumberFormatException e) {
                    log.error("Invalid value for CASSANDRA_THRIFT_SOCKET_TIMEOUT", (Throwable)e);
                }
            }
        }
        return timeoutVar;
    }

    @Override
    public void startToUse() {
        this.useageStartTime = System.currentTimeMillis();
    }

    @Override
    public long getSinceLastUsed() {
        return System.currentTimeMillis() - this.useageStartTime;
    }

    public String toString() {
        return String.format(NAME_FORMAT, this.cassandraHost.getUrl(), this.mySerial);
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    @Override
    public CassandraHost getCassandraHost() {
        return this.cassandraHost;
    }

    @Override
    public boolean isAlreadyAuthenticated(Map<String, String> credentials) {
        return credentials != null && ((Object)this.credentials).equals(credentials);
    }

    @Override
    public void clearAuthentication() {
        this.credentials.clear();
    }

    @Override
    public void setAuthenticated(Map<String, String> credentials) {
        this.clearAuthentication();
        this.credentials.putAll(credentials);
    }
}

