/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.model.thrift;

import me.prettyprint.cassandra.model.AbstractSuperColumnQuery;
import me.prettyprint.cassandra.model.HSuperColumnImpl;
import me.prettyprint.cassandra.model.KeyspaceOperationCallback;
import me.prettyprint.cassandra.model.QueryResultImpl;
import me.prettyprint.cassandra.model.thrift.ThriftFactory;
import me.prettyprint.cassandra.service.KeyspaceService;
import me.prettyprint.cassandra.utils.Assert;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.Serializer;
import me.prettyprint.hector.api.beans.HSuperColumn;
import me.prettyprint.hector.api.exceptions.HNotFoundException;
import me.prettyprint.hector.api.exceptions.HectorException;
import me.prettyprint.hector.api.query.QueryResult;
import me.prettyprint.hector.api.query.SuperColumnQuery;
import org.apache.cassandra.thrift.ColumnPath;
import org.apache.cassandra.thrift.SuperColumn;

public final class ThriftSuperColumnQuery<K, SN, N, V>
extends AbstractSuperColumnQuery<K, SN, N, V>
implements SuperColumnQuery<K, SN, N, V> {
    public ThriftSuperColumnQuery(Keyspace keyspace, Serializer<K> keySerializer, Serializer<SN> sNameSerializer, Serializer<N> nameSerializer, Serializer<V> valueSerializer) {
        super(keyspace, keySerializer, sNameSerializer, nameSerializer, valueSerializer);
    }

    @Override
    public QueryResult<HSuperColumn<SN, N, V>> execute() {
        Assert.notNull(this.columnFamilyName, "columnFamilyName is null");
        Assert.notNull(this.superName, "superName is null");
        return new QueryResultImpl<HSuperColumn<SN, N, V>>(this.keyspace.doExecute(new KeyspaceOperationCallback<HSuperColumn<SN, N, V>>(){

            @Override
            public HSuperColumn<SN, N, V> doInKeyspace(KeyspaceService ks) throws HectorException {
                try {
                    ColumnPath cpath = ThriftFactory.createSuperColumnPath(ThriftSuperColumnQuery.this.columnFamilyName, ThriftSuperColumnQuery.this.superName, null, ThriftSuperColumnQuery.this.sNameSerializer, ThriftSuperColumnQuery.this.columnNameSerializer);
                    SuperColumn thriftSuperColumn = ks.getSuperColumn(ThriftSuperColumnQuery.this.keySerializer.toByteBuffer(ThriftSuperColumnQuery.this.key), cpath);
                    if (thriftSuperColumn == null) {
                        return null;
                    }
                    return new HSuperColumnImpl(thriftSuperColumn, ThriftSuperColumnQuery.this.sNameSerializer, ThriftSuperColumnQuery.this.columnNameSerializer, ThriftSuperColumnQuery.this.valueSerializer);
                }
                catch (HNotFoundException e) {
                    return null;
                }
            }
        }), this);
    }
}

