/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.stream.VersionManager;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;

public class ResultObjectUtil {
    private int columnCount;
    private Class[] typeArray;
    private IResultClass rsMetaData;
    private DataEngineSession session;

    public static ResultObjectUtil newInstance(IResultClass rsMetaData, DataEngineSession session) {
        ResultObjectUtil instance = new ResultObjectUtil();
        int length = rsMetaData.getFieldCount();
        instance.typeArray = new Class[length];
        int i = 0;
        while (i < length) {
            try {
                instance.typeArray[i] = rsMetaData.getFieldValueClass(i + 1);
            }
            catch (DataException dataException) {
                // empty catch block
            }
            ++i;
        }
        instance.columnCount = rsMetaData.getFieldCount();
        instance.rsMetaData = rsMetaData;
        instance.session = session;
        return instance;
    }

    private ResultObjectUtil() {
    }

    public ResultObject newResultObject(Object[] rowData) {
        return new ResultObject(this.rsMetaData, rowData);
    }

    public IResultObject[] readData(InputStream bis, ClassLoader classLoader, int length) throws IOException, DataException {
        IResultObject[] rowDatas = new ResultObject[length];
        int i = 0;
        while (i < length) {
            int readSize;
            if (this.session.getStopSign().isStopped()) break;
            int rowLen = IOUtil.readInt((InputStream)bis);
            byte[] rowDataBytes = new byte[rowLen];
            int totalSize = readSize = bis.read(rowDataBytes);
            while (readSize > 0 && totalSize < rowLen) {
                readSize = bis.read(rowDataBytes, totalSize, rowLen - totalSize);
                totalSize += readSize;
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(rowDataBytes);
            DataInputStream dis = new DataInputStream(bais);
            Object[] obs = new Object[this.columnCount];
            int j = 0;
            while (j < this.columnCount) {
                Class fieldType = this.typeArray[j];
                obs[j] = ResultObjectUtil.readObject(dis, fieldType, classLoader, VersionManager.getLatestVersion());
                ++j;
            }
            rowDatas[i] = this.newResultObject(obs);
            rowDataBytes = null;
            dis = null;
            bais = null;
            ++i;
        }
        return rowDatas;
    }

    public static Object readObject(DataInputStream dis, Class fieldType, ClassLoader classLoader, int version) throws IOException, DataException {
        Object obj = null;
        char leadingChar = (char)dis.read();
        if (leadingChar == '\u0000') {
            obj = null;
            return obj;
        }
        if (fieldType.equals(Integer.class)) {
            obj = dis.readInt();
        } else if (fieldType.equals(Double.class)) {
            obj = new Double(dis.readDouble());
        } else if (fieldType.equals(BigDecimal.class)) {
            obj = new BigDecimal(dis.readUTF());
        } else if (fieldType.equals(Time.class)) {
            obj = new Time(dis.readLong());
        } else if (fieldType.equals(Timestamp.class)) {
            obj = new Timestamp(dis.readLong());
        } else if (fieldType.equals(Date.class)) {
            try {
                obj = DataTypeUtil.toSqlDate((Object)new Date(dis.readLong()));
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
        } else if (java.util.Date.class.isAssignableFrom(fieldType)) {
            obj = new java.util.Date(dis.readLong());
        } else if (fieldType.equals(Boolean.class)) {
            obj = dis.readBoolean();
        } else if (fieldType.equals(String.class)) {
            obj = IOUtil.readString((DataInputStream)dis);
        } else if (fieldType.equals(IClob.class) || fieldType.equals(Clob.class)) {
            obj = IOUtil.readString((DataInputStream)dis);
        } else if (fieldType.equals(IBlob.class) || fieldType.equals(Blob.class)) {
            if (version < 300) {
                int len = IOUtil.readInt((InputStream)dis);
                if (len == 0) {
                    obj = null;
                } else {
                    byte[] bytes = new byte[len];
                    dis.read(bytes);
                    obj = bytes;
                }
            } else {
                int byteLength = leadingChar >> 1;
                if (byteLength >= 127) {
                    byteLength = IOUtil.readInt((InputStream)dis);
                }
                byte[] bytes = new byte[byteLength];
                dis.readFully(bytes);
                obj = bytes;
            }
        } else if (fieldType.equals(int[].class)) {
            int[] result = new int[IOUtil.readInt((InputStream)dis)];
            int i = 0;
            while (i < result.length) {
                result[i] = dis.readInt();
                ++i;
            }
            obj = result;
        } else if (fieldType.equals(Object.class) || fieldType.equals(DataType.getClass((int)0))) {
            obj = IOUtil.readObject((DataInputStream)dis, (ClassLoader)classLoader);
        } else {
            throw new DataException("data.engine.BadDataType", fieldType.toString());
        }
        return obj;
    }

    public void writeData(OutputStream bos, IResultObject[] resultObjects, int length) throws IOException, DataException {
        int i = 0;
        while (i < length) {
            this.writeData(bos, resultObjects[i]);
            if (this.session.getStopSign().isStopped()) {
                return;
            }
            ++i;
        }
    }

    public void writeData(OutputStream bos, IResultObject resultObject) throws IOException, DataException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        int j = 0;
        while (j < this.columnCount) {
            Object fieldValue = null;
            try {
                fieldValue = resultObject.getFieldValue(j + 1);
            }
            catch (DataException dataException) {
                // empty catch block
            }
            Class fieldType = this.typeArray[j];
            ResultObjectUtil.writeObject(dos, fieldValue, fieldType, VersionManager.getLatestVersion());
            ++j;
        }
        dos.flush();
        byte[] rowsDataBytes = baos.toByteArray();
        IOUtil.writeInt((OutputStream)bos, (int)rowsDataBytes.length);
        bos.write(rowsDataBytes);
        rowsDataBytes = null;
        dos = null;
        baos = null;
    }

    public static void writeObject(DataOutputStream dos, Object fieldValue, Class fieldType, int version) throws IOException, DataException {
        Object convertedObj = null;
        if (fieldValue != null) {
            convertedObj = fieldType.equals(Integer.class) ? ResultObjectUtil.convert(fieldValue, 2) : (fieldType.equals(Double.class) ? ResultObjectUtil.convert(fieldValue, 3) : (fieldType.equals(BigDecimal.class) ? ResultObjectUtil.convert(fieldValue, 4) : (java.util.Date.class.isAssignableFrom(fieldType) ? ResultObjectUtil.convert(fieldValue, 6) : (fieldType.equals(Boolean.class) ? ResultObjectUtil.convert(fieldValue, 1) : fieldValue))));
        }
        int leadingChar = 0;
        if (convertedObj == null) {
            dos.write(leadingChar);
            return;
        }
        leadingChar = 1;
        if (fieldType.equals(Integer.class)) {
            dos.write(leadingChar);
            dos.writeInt((Integer)convertedObj);
        } else if (fieldType.equals(Double.class)) {
            dos.write(leadingChar);
            dos.writeDouble((Double)convertedObj);
        } else if (fieldType.equals(BigDecimal.class)) {
            dos.write(leadingChar);
            dos.writeUTF(((BigDecimal)convertedObj).toString());
        } else if (java.util.Date.class.isAssignableFrom(fieldType)) {
            dos.write(leadingChar);
            dos.writeLong(((java.util.Date)convertedObj).getTime());
        } else if (fieldType.equals(Boolean.class)) {
            dos.write(leadingChar);
            dos.writeBoolean((Boolean)convertedObj);
        } else if (fieldType.equals(String.class)) {
            dos.write(leadingChar);
            IOUtil.writeString((DataOutputStream)dos, (String)fieldValue.toString());
        } else if (fieldType.equals(IClob.class) || fieldType.equals(Clob.class)) {
            dos.write(leadingChar);
            IOUtil.writeString((DataOutputStream)dos, (String)fieldValue.toString());
        } else if (fieldType.equals(IBlob.class) || fieldType.equals(Blob.class)) {
            byte[] bytes = (byte[])fieldValue;
            if (version < 300) {
                dos.write(leadingChar);
                if (bytes == null || bytes.length == 0) {
                    IOUtil.writeInt((OutputStream)dos, (int)0);
                } else {
                    IOUtil.writeInt((OutputStream)dos, (int)bytes.length);
                    dos.write((byte[])fieldValue);
                }
            } else {
                int byteLength = bytes.length;
                if (byteLength < 127) {
                    leadingChar = (char)(byteLength << 1 | leadingChar);
                    dos.write(leadingChar);
                } else {
                    leadingChar = (char)(0xFE | leadingChar);
                    dos.write(leadingChar);
                    IOUtil.writeInt((OutputStream)dos, (int)bytes.length);
                }
                dos.write((byte[])fieldValue);
            }
        } else if (fieldType.equals(Object.class) || fieldType.equals(DataType.getClass((int)0))) {
            if (!(fieldValue instanceof Serializable)) {
                throw new DataException("data.engine.NotSerializableClass", fieldValue.getClass().getName());
            }
            dos.write(leadingChar);
            IOUtil.writeObject((DataOutputStream)dos, (Object)fieldValue);
        } else {
            throw new DataException("data.engine.BadDataType", fieldType.toString());
        }
    }

    private static Object convert(Object o, int type) throws DataException {
        try {
            return DataTypeUtil.convert((Object)o, (int)type);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

