/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.conversation;

import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.ConversationNode;
import org.eclipse.bpmn2.modeler.core.features.AbstractBpmn2AddFeature;
import org.eclipse.bpmn2.modeler.core.features.label.AddShapeLabelFeature;
import org.eclipse.bpmn2.modeler.core.utils.StyleUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.impl.AddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Polygon;
import org.eclipse.graphiti.mm.algorithms.Rectangle;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public abstract class AddConversationNodeFeature<T extends ConversationNode>
extends AbstractBpmn2AddFeature<T> {
    public AddConversationNodeFeature(IFeatureProvider fp) {
        super(fp);
    }

    public IAddFeature getAddLabelFeature(IFeatureProvider fp) {
        return new AddShapeLabelFeature(fp);
    }

    public boolean canAdd(IAddContext context) {
        return context.getTargetContainer().equals(this.getDiagram());
    }

    public PictogramElement add(IAddContext context) {
        IGaService gaService = Graphiti.getGaService();
        IPeService peService = Graphiti.getPeService();
        ConversationNode businessObject = (ConversationNode)this.getBusinessObject(context);
        int width = this.getWidth(context);
        int height = this.getHeight(context);
        ContainerShape containerShape = peService.createContainerShape(context.getTargetContainer(), true);
        Rectangle rect = gaService.createInvisibleRectangle((PictogramElement)containerShape);
        gaService.setLocationAndSize((GraphicsAlgorithm)rect, context.getX(), context.getY(), width, height);
        Shape hexShape = peService.createShape(containerShape, false);
        int w_5th = width / 5;
        int[] nArray = new int[12];
        nArray[0] = w_5th;
        nArray[2] = w_5th * 4;
        nArray[4] = width;
        nArray[5] = height / 2;
        nArray[6] = w_5th * 4;
        nArray[7] = height;
        nArray[8] = w_5th;
        nArray[9] = height;
        nArray[11] = height / 2;
        int[] xy = nArray;
        Polygon hexagon = gaService.createPolygon((GraphicsAlgorithmContainer)hexShape, xy);
        StyleUtil.applyStyle((GraphicsAlgorithm)hexagon, (BaseElement)businessObject);
        this.link((PictogramElement)containerShape, businessObject);
        boolean isImport = context.getProperty((Object)"is.importing") != null;
        this.createDIShape((Shape)containerShape, (BaseElement)businessObject, !isImport);
        ((AddContext)context).setWidth(width);
        ((AddContext)context).setHeight(height);
        this.decorateShape(context, containerShape, (BaseElement)businessObject);
        peService.createChopboxAnchor((AnchorContainer)containerShape);
        return containerShape;
    }
}

