/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import org.eclipse.bpmn2.modeler.core.DefaultConversionDelegate;
import org.eclipse.bpmn2.modeler.core.EditControlProvider;
import org.eclipse.bpmn2.modeler.ui.Activator;
import org.eclipse.bpmn2.modeler.ui.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class EFontConversionDelegate
extends DefaultConversionDelegate {
    private static FontData systemFontData;

    public String convertToString(Object value) {
        if (value instanceof FontData) {
            FontData fd = (FontData)value;
            int style = fd.getStyle();
            boolean isItalic = (style & 2) != 0;
            boolean isBold = (style & 1) != 0;
            return new String(String.valueOf(fd.getName()) + "," + fd.height + "," + (isItalic ? "I" : "-") + "," + (isBold ? "B" : "-"));
        }
        return Display.getDefault().getSystemFont().getFontData()[0].toString();
    }

    public Object createFromString(String literal) {
        try {
            String[] a = literal.split(",");
            if (a.length == 4) {
                String name = a[0];
                int height = (int)Math.round(Double.parseDouble(a[1]));
                int style = 0;
                if ("I".equals(a[2])) {
                    style |= 2;
                }
                if ("B".equals(a[3])) {
                    style |= 1;
                }
                return new FontData(name, height, style);
            }
        }
        catch (Exception e) {
            Activator.logError(e);
        }
        return EFontConversionDelegate.getSystemFontData();
    }

    private static FontData getSystemFontData() {
        if (systemFontData == null) {
            try {
                systemFontData = Display.getDefault().getSystemFont().getFontData()[0];
            }
            catch (Exception exception) {}
        }
        if (systemFontData != null) {
            return systemFontData;
        }
        return new FontData("arial", 12, 0);
    }

    public EditControlProvider.EditControl createControl(Composite parent, int style) {
        return new FontControl(parent, style);
    }

    public class FontControl
    extends EditControlProvider.EditControl {
        private Button changeFontButton;
        private FontData[] selectedFont;
        private Font previewLabelFont;
        private Label previewLabel;

        public FontControl(Composite parent, int style) {
            super(parent, style);
            this.changeFontButton = null;
            this.setLayout((Layout)new GridLayout(2, false));
            this.previewLabel = new Label((Composite)this, 16384);
            this.previewLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.previewLabel.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontControl.this.previewLabel = null;
                    if (FontControl.this.previewLabelFont != null) {
                        FontControl.this.previewLabelFont.dispose();
                        FontControl.this.previewLabelFont = null;
                    }
                }
            });
            this.changeFontButton = new Button((Composite)this, 8);
            this.changeFontButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.changeFontButton.setText(Messages.Bpmn2EditorPreferencePage_Change_Button);
            this.changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    FontData font;
                    FontDialog fontDialog = new FontDialog(FontControl.this.changeFontButton.getShell());
                    if (FontControl.this.selectedFont != null) {
                        fontDialog.setFontList(FontControl.this.selectedFont);
                    }
                    if ((font = fontDialog.open()) != null) {
                        FontData[] oldFont = FontControl.this.selectedFont;
                        if (oldFont == null) {
                            oldFont = JFaceResources.getDefaultFont().getFontData();
                        }
                        FontControl.this.setSelectedFont(font);
                    }
                }
            });
            this.changeFontButton.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FontControl.this.changeFontButton = null;
                }
            });
            this.changeFontButton.addSelectionListener((SelectionListener)this);
        }

        public Object getValue() {
            if (this.selectedFont != null && this.selectedFont.length > 0) {
                return this.selectedFont[0];
            }
            return null;
        }

        public boolean setValue(Object value) {
            if (value instanceof FontData) {
                this.setSelectedFont((FontData)value);
            } else {
                this.setSelectedFont(this.getDefaultFontData()[0]);
            }
            return true;
        }

        private void setSelectedFont(FontData fd) {
            fd.setHeight(Math.round(fd.getHeight()));
            FontData[] bestFont = JFaceResources.getFontRegistry().filterData(new FontData[]{fd}, this.previewLabel.getDisplay());
            if (bestFont == null) {
                bestFont = this.getDefaultFontData();
            }
            this.selectedFont = bestFont;
            if (this.previewLabel != null) {
                if (this.previewLabelFont != null) {
                    this.previewLabelFont.dispose();
                }
                this.previewLabelFont = new Font((Device)Display.getDefault(), this.selectedFont[0]);
                this.previewLabel.setFont(this.previewLabelFont);
                this.previewLabel.setText(StringConverter.asString((FontData)this.selectedFont[0]));
                this.layout();
            }
        }

        private FontData[] getDefaultFontData() {
            return this.previewLabel.getDisplay().getSystemFont().getFontData();
        }
    }
}

