/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2SectionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.PropertyTabDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.bpmn2.modeler.ui.property.AdvancedPropertySection;
import org.eclipse.bpmn2.modeler.ui.property.TabDescriptorList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;

public class PropertyTabDescriptorProvider
implements ITabDescriptorProvider {
    static Hashtable<EObject, TabDescriptorList> tabDescriptorListMap = new Hashtable();

    public ITabDescriptor[] getTabDescriptors(IWorkbenchPart part, ISelection selection) {
        EObject businessObject = BusinessObjectUtil.getBusinessObjectForSelection((ISelection)selection);
        if (businessObject == null || businessObject.eResource() == null) {
            if (businessObject == null) {
                System.err.println("PropertyTabDescriptorProvider#getTabDescriptors() businessObject is null");
            } else {
                System.err.println("PropertyTabDescriptorProvider#getTabDescriptors() businessObject '" + businessObject + "' is not contained in a Resource");
            }
            return new ITabDescriptor[0];
        }
        TabDescriptorList tabDescriptorList = tabDescriptorListMap.get(businessObject);
        if (tabDescriptorList != null) {
            return tabDescriptorList.toArray();
        }
        List tabDescriptors = null;
        TargetRuntime rt = TargetRuntime.getRuntime((EObject)businessObject);
        if (rt != TargetRuntime.getDefaultRuntime()) {
            tabDescriptors = TargetRuntime.getDefaultRuntime().buildPropertyTabDescriptors();
            tabDescriptors.addAll(rt.buildPropertyTabDescriptors());
        } else {
            tabDescriptors = rt.buildPropertyTabDescriptors();
        }
        ArrayList<PropertyTabDescriptor> replaced = new ArrayList<PropertyTabDescriptor>();
        for (PropertyTabDescriptor d : tabDescriptors) {
            String[] replacements;
            String replacedId = d.getReplaceTab();
            if (replacedId == null) continue;
            String[] stringArray = replacements = replacedId.split(" ");
            int n = replacements.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                for (Bpmn2SectionDescriptor s : d.getSectionDescriptors()) {
                    PropertyTabDescriptor replacedTab;
                    if (!s.doReplaceTab(id, part, selection) || (replacedTab = TargetRuntime.findPropertyTabDescriptor((String)id)) == null) continue;
                    replaced.add(replacedTab);
                    int i = tabDescriptors.indexOf(replacedTab);
                    if (i < 0) continue;
                    tabDescriptors.set(i, d);
                }
                ++n2;
            }
        }
        if (replaced.size() > 0) {
            tabDescriptors.removeAll(replaced);
        }
        int i = tabDescriptors.size() - 1;
        while (i >= 0) {
            PropertyTabDescriptor d = (PropertyTabDescriptor)tabDescriptors.get(i);
            int j = i - 1;
            while (j >= 0) {
                if (tabDescriptors.get(j) == d) {
                    tabDescriptors.remove(i);
                    break;
                }
                --j;
            }
            --i;
        }
        ArrayList<PropertyTabDescriptor> nonapplicableTabs = new ArrayList<PropertyTabDescriptor>();
        PropertyTabDescriptor advancedPropertyTab = null;
        for (PropertyTabDescriptor descriptor : tabDescriptors) {
            boolean empty = true;
            for (Bpmn2SectionDescriptor s : descriptor.getSectionDescriptors()) {
                if (s.appliesTo(part, selection)) {
                    empty = false;
                }
                if (!(s.getSectionClass() instanceof AdvancedPropertySection)) continue;
                advancedPropertyTab = descriptor;
            }
            if (!empty) continue;
            nonapplicableTabs.add(descriptor);
        }
        if (nonapplicableTabs.size() > 0) {
            tabDescriptors.removeAll(nonapplicableTabs);
        }
        if (advancedPropertyTab != null && tabDescriptors.remove(advancedPropertyTab)) {
            tabDescriptors.add(advancedPropertyTab);
        }
        replaced.clear();
        for (PropertyTabDescriptor td : tabDescriptors) {
            String rtid = td.getRuntimeId();
            if (rtid != null && !rtid.equals("org.eclipse.bpmn2.modeler.runtime.none") && !rt.getId().equals(rtid) || td.getConfigFile() != null && !rt.getId().equals(rtid)) continue;
            replaced.add(td.copy());
        }
        if (businessObject != null) {
            tabDescriptorList = new TabDescriptorList();
            tabDescriptorList.addAll(replaced);
            tabDescriptorListMap.put(businessObject, tabDescriptorList);
            return tabDescriptorList.toArray();
        }
        return replaced.toArray(new ITabDescriptor[replaced.size()]);
    }

    public void disposeTabDescriptors(Resource resource) {
        if (resource != null) {
            TreeIterator iter = resource.getAllContents();
            while (iter.hasNext()) {
                EObject object = (EObject)iter.next();
                tabDescriptorListMap.remove(object);
            }
        }
        ArrayList<EObject> removed = new ArrayList<EObject>();
        for (EObject o : tabDescriptorListMap.keySet()) {
            if (o.eResource() != null) continue;
            removed.add(o);
        }
        for (EObject o : removed) {
            tabDescriptorListMap.remove(o);
        }
    }
}

