/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.console;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.internal.console.ProcessDescription;
import org.eclipse.buildship.core.internal.console.ProcessStreams;
import org.eclipse.buildship.core.internal.console.ProcessStreamsProvider;
import org.eclipse.buildship.ui.internal.console.ConsoleMessages;
import org.eclipse.buildship.ui.internal.console.GradleConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;

public final class ConsoleProcessStreamsProvider
implements ProcessStreamsProvider {
    public synchronized ProcessStreams getBackgroundJobProcessStreams() {
        return BackgroundJobProcessStream.INSTANCE;
    }

    public ProcessStreams createProcessStreams(ProcessDescription processDescription) {
        Preconditions.checkNotNull((Object)processDescription);
        return ConsoleProcessStreamsProvider.createAndRegisterNewConsole(processDescription);
    }

    private static GradleConsole createAndRegisterNewConsole(ProcessDescription processDescription) {
        GradleConsole gradleConsole = new GradleConsole(processDescription);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{gradleConsole});
        return gradleConsole;
    }

    private static GradleConsole createAndRegisterNewConsole(String name) {
        GradleConsole gradleConsole = new GradleConsole(name);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{gradleConsole});
        return gradleConsole;
    }

    static /* synthetic */ GradleConsole access$100(String x0) {
        return ConsoleProcessStreamsProvider.createAndRegisterNewConsole(x0);
    }

    private static final class BackgroundJobProcessStream {
        private static final GradleConsole INSTANCE = ConsoleProcessStreamsProvider.access$100(ConsoleMessages.Background_Console_Title);

        private BackgroundJobProcessStream() {
        }
    }
}

