/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.PrintStream;
import org.gradle.tooling.internal.adapter.CompatibleIntrospector;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.connection.AbstractConsumerConnection;
import org.gradle.tooling.internal.consumer.connection.ActionRunner;
import org.gradle.tooling.internal.consumer.connection.BuildInvocationsAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.GradleBuildAdapterProducer;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.connection.UnsupportedActionRunner;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.idea.BasicIdeaProject;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.tooling.model.internal.Exceptions;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GradleVersion;

public class InternalConnectionBackedConsumerConnection
extends AbstractConsumerConnection {
    private final ModelProducer modelProducer;
    private final UnsupportedActionRunner actionRunner;

    public InternalConnectionBackedConsumerConnection(ConnectionVersion4 delegate, ModelMapping modelMapping, ProtocolToModelAdapter adapter) {
        super(delegate, new R10M8VersionDetails(delegate.getMetaData().getVersion()));
        ModelProducer modelProducer = new InternalConnectionBackedModelProducer(adapter, this.getVersionDetails(), modelMapping, (InternalConnection)delegate, this);
        modelProducer = new GradleBuildAdapterProducer(adapter, modelProducer, this);
        modelProducer = new BuildInvocationsAdapterProducer(adapter, this.getVersionDetails(), modelProducer);
        modelProducer = new BuildExecutingModelProducer(modelProducer);
        if (GradleVersion.version(this.getVersionDetails().getVersion()).compareTo(GradleVersion.version("1.0")) < 0) {
            modelProducer = new NoCommandLineArgsModelProducer(modelProducer);
        }
        modelProducer = new DeprecationWarningModelProducer(modelProducer);
        this.modelProducer = modelProducer;
        this.actionRunner = new UnsupportedActionRunner(this.getVersionDetails().getVersion());
    }

    protected ActionRunner getActionRunner() {
        return this.actionRunner;
    }

    protected ModelProducer getModelProducer() {
        return this.modelProducer;
    }

    public void configure(ConnectionParameters connectionParameters) {
        new CompatibleIntrospector(this.getDelegate()).callSafely("configureLogging", connectionParameters.getVerboseLogging());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildExecutingModelProducer
    implements ModelProducer {
        private final ModelProducer delegate;

        private BuildExecutingModelProducer(ModelProducer delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            if (type.equals(Void.class)) {
                InternalConnectionBackedConsumerConnection.this.getDelegate().executeBuild(operationParameters, operationParameters);
                return null;
            }
            if (operationParameters.getTasks() != null) {
                throw Exceptions.unsupportedOperationConfiguration(operationParameters.getEntryPointName() + " forTasks()", InternalConnectionBackedConsumerConnection.this.getVersionDetails().getVersion(), "1.2");
            }
            return this.delegate.produceModel(type, operationParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeprecationWarningModelProducer
    implements ModelProducer {
        private final ModelProducer delegate;

        public DeprecationWarningModelProducer(ModelProducer delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            String message = "Support for Gradle version " + InternalConnectionBackedConsumerConnection.this.getVersionDetails().getVersion() + " is deprecated and will be removed in tooling API version 3.0. You should upgrade your Gradle build to use Gradle 1.2 or later.";
            DeprecationLogger.nagUserWith(message);
            if (operationParameters.getStandardOutput() != null) {
                PrintStream printStream = new PrintStream(operationParameters.getStandardOutput());
                printStream.println(message);
                printStream.flush();
            }
            return this.delegate.produceModel(type, operationParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InternalConnectionBackedModelProducer
    implements ModelProducer {
        private final ProtocolToModelAdapter adapter;
        private final VersionDetails versionDetails;
        private final ModelMapping modelMapping;
        private final InternalConnection delegate;
        private final HasCompatibilityMapping mapperProvider;

        public InternalConnectionBackedModelProducer(ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, InternalConnection delegate, HasCompatibilityMapping mapperProvider) {
            this.adapter = adapter;
            this.versionDetails = versionDetails;
            this.modelMapping = modelMapping;
            this.delegate = delegate;
            this.mapperProvider = mapperProvider;
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            if (!this.versionDetails.maySupportModel(type)) {
                throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
            }
            Class<?> protocolType = this.modelMapping.getProtocolType(type);
            return this.adapter.adapt(type, this.delegate.getTheModel(protocolType, operationParameters), this.mapperProvider.getCompatibilityMapping(operationParameters));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NoCommandLineArgsModelProducer
    implements ModelProducer {
        private final ModelProducer delegate;

        public NoCommandLineArgsModelProducer(ModelProducer delegate) {
            this.delegate = delegate;
        }

        @Override
        public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
            if (operationParameters.getArguments() != null && !operationParameters.getArguments().isEmpty()) {
                throw Exceptions.unsupportedOperationConfiguration(operationParameters.getEntryPointName() + " withArguments()", InternalConnectionBackedConsumerConnection.this.getVersionDetails().getVersion(), "1.0");
            }
            return this.delegate.produceModel(type, operationParameters);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class R10M8VersionDetails
    extends VersionDetails {
        public R10M8VersionDetails(String version) {
            super(version);
        }

        @Override
        public boolean maySupportModel(Class<?> modelType) {
            return modelType.equals(Void.class) || modelType.equals(HierarchicalEclipseProject.class) || modelType.equals(EclipseProject.class) || modelType.equals(IdeaProject.class) || modelType.equals(BasicIdeaProject.class) || modelType.equals(GradleProject.class) || modelType.equals(BuildEnvironment.class);
        }
    }
}

