/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.gradle.tooling.TestLauncher;
import org.gradle.tooling.events.test.TestOperationDescriptor;

public final class TestConfig {
    private final ImmutableList<String> jvmTestClasses;
    private final ImmutableList<TestOperationDescriptor> tests;

    private TestConfig(List<String> jvmTestClasses, List<TestOperationDescriptor> tests) {
        this.jvmTestClasses = ImmutableList.copyOf(jvmTestClasses);
        this.tests = ImmutableList.copyOf(tests);
        this.checkNotAllListsEmpty(jvmTestClasses, tests);
    }

    private void checkNotAllListsEmpty(List<String> jvmTestClasses, List<TestOperationDescriptor> tests) {
        Preconditions.checkArgument((!jvmTestClasses.isEmpty() || !tests.isEmpty() ? 1 : 0) != 0, (Object)"Either JVM test classes or test operations, or both, must be specified.");
    }

    public void apply(TestLauncher testLauncher) {
        Preconditions.checkNotNull((Object)testLauncher);
        testLauncher.withJvmTestClasses(this.jvmTestClasses);
        testLauncher.withTests(this.tests);
    }

    public static TestConfig forJvmTestClasses(String ... jvmTestClasses) {
        return new Builder().jvmTestClasses(jvmTestClasses).build();
    }

    public static TestConfig forJvmTestClasses(Iterable<String> jvmTestClasses) {
        return new Builder().jvmTestClasses(jvmTestClasses).build();
    }

    public static TestConfig forTests(TestOperationDescriptor ... tests) {
        return new Builder().tests(tests).build();
    }

    public static TestConfig forTests(Iterable<? extends TestOperationDescriptor> tests) {
        return new Builder().tests(tests).build();
    }

    public static final class Builder {
        private ImmutableList.Builder<String> jvmTestClasses = ImmutableList.builder();
        private ImmutableList.Builder<TestOperationDescriptor> tests = ImmutableList.builder();

        public Builder jvmTestClasses(String ... jvmTestClasses) {
            this.jvmTestClasses.addAll(Arrays.asList(jvmTestClasses));
            return this;
        }

        public Builder jvmTestClasses(Iterable<String> jvmTestClasses) {
            this.jvmTestClasses.addAll(jvmTestClasses);
            return this;
        }

        public Builder tests(TestOperationDescriptor ... tests) {
            this.tests.addAll(Arrays.asList(tests));
            return this;
        }

        public Builder tests(Iterable<? extends TestOperationDescriptor> tests) {
            this.tests.addAll(tests);
            return this;
        }

        public TestConfig build() {
            return new TestConfig((List)this.jvmTestClasses.build(), (List)this.tests.build());
        }
    }
}

