/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelectionProvider;
import org.eclipse.buildship.ui.util.nodeselection.SelectionSpecificAction;
import org.eclipse.buildship.ui.view.execution.ExecutionViewMessages;
import org.eclipse.buildship.ui.view.execution.OpenTestSourceFileJob;
import org.eclipse.buildship.ui.view.execution.OperationItem;
import org.eclipse.jface.action.Action;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.test.JvmTestOperationDescriptor;

public final class OpenTestSourceFileAction
extends Action
implements SelectionSpecificAction {
    private final NodeSelectionProvider selectionProvider;

    public OpenTestSourceFileAction(NodeSelectionProvider selectionProvider) {
        super(ExecutionViewMessages.Action_OpenTestSourceFile_Text);
        this.selectionProvider = selectionProvider;
    }

    public void run() {
        ImmutableList<OperationItem> selectedTestOperationItems = this.selectionProvider.getSelection().getNodes(OperationItem.class);
        OpenTestSourceFileJob openTestSourceFileJob = new OpenTestSourceFileJob((List<OperationItem>)selectedTestOperationItems);
        openTestSourceFileJob.schedule();
    }

    @Override
    public boolean isVisibleFor(NodeSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (!selection.hasAllNodesOfType(OperationItem.class)) {
            return false;
        }
        ImmutableList<OperationItem> operationItems = selection.getNodes(OperationItem.class);
        return FluentIterable.from(operationItems).allMatch((Predicate)new Predicate<OperationItem>(){

            public boolean apply(OperationItem operationItem) {
                OperationDescriptor adapter = (OperationDescriptor)operationItem.getAdapter(OperationDescriptor.class);
                return adapter instanceof JvmTestOperationDescriptor;
            }
        });
    }

    @Override
    public boolean isEnabledFor(NodeSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        if (!selection.hasAllNodesOfType(OperationItem.class)) {
            return false;
        }
        ImmutableList<OperationItem> operationItems = selection.getNodes(OperationItem.class);
        return FluentIterable.from(operationItems).allMatch((Predicate)new Predicate<OperationItem>(){

            public boolean apply(OperationItem operationItem) {
                OperationDescriptor adapter = (OperationDescriptor)operationItem.getAdapter(OperationDescriptor.class);
                return adapter instanceof JvmTestOperationDescriptor && ((JvmTestOperationDescriptor)adapter).getClassName() != null;
            }
        });
    }

    @Override
    public void setEnabledFor(NodeSelection selection) {
        this.setEnabled(this.isEnabledFor(selection));
    }
}

