/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite;

import java.io.File;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.DefaultExecutorFactory;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.composite.CompositeBuildConnection;
import org.gradle.tooling.composite.CompositeParticipant;
import org.gradle.tooling.composite.internal.CompositeBuildConnectorFactory;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultConnectionParameters;
import org.gradle.tooling.internal.consumer.DefaultExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.DistributionFactory;
import org.gradle.tooling.internal.consumer.ExecutorServiceFactory;
import org.gradle.tooling.internal.consumer.LoggingProvider;
import org.gradle.tooling.internal.consumer.SynchronizedLogging;
import org.gradle.tooling.internal.consumer.loader.CachingToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.DefaultToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.SynchronizedToolingImplementationLoader;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;

public abstract class CompositeBuildConnector {
    private static final ToolingImplementationLoader toolingImplementationLoader = new SynchronizedToolingImplementationLoader((ToolingImplementationLoader)new CachingToolingImplementationLoader((ToolingImplementationLoader)new DefaultToolingImplementationLoader()));
    private static final ExecutorFactory executorFactory = new DefaultExecutorFactory();
    private static final LoggingProvider loggingProvider = new SynchronizedLogging();
    private static final ExecutorServiceFactory executorServiceFactory = new DefaultExecutorServiceFactory();
    private static final DistributionFactory distributionFactory = new DistributionFactory((Factory)executorServiceFactory);
    private static final DefaultConnectionParameters.Builder connectionParamsBuilder = DefaultConnectionParameters.builder();
    private static final CompositeBuildConnectorFactory gradleCompositeFactory = new CompositeBuildConnectorFactory(toolingImplementationLoader, executorFactory, loggingProvider);

    public static CompositeBuildConnector newComposite() {
        DefaultConnectionParameters parameters = connectionParamsBuilder.build();
        Distribution distribution = distributionFactory.getClasspathDistribution();
        return gradleCompositeFactory.create(distribution, (ConnectionParameters)parameters);
    }

    public abstract CompositeParticipant addParticipant(File var1);

    public abstract CompositeBuildConnection connect() throws GradleConnectionException;
}

