/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.gradle.api.GradleException;
import org.gradle.impldep.com.google.common.base.Joiner;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.reflect.NoSuchMethodException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaMethod<T, R> {
    private final Method method;
    private final Class<R> returnType;

    public JavaMethod(Class<T> target, Class<R> returnType, String name, boolean allowStatic, Class<?> ... paramTypes) {
        this.returnType = returnType;
        this.method = this.findMethod(target, target, name, allowStatic, paramTypes);
        this.method.setAccessible(true);
    }

    public JavaMethod(Class<T> target, Class<R> returnType, String name, Class<?> ... paramTypes) {
        this(target, returnType, name, false, paramTypes);
    }

    public JavaMethod(Class<T> target, Class<R> returnType, Method method) {
        this.returnType = returnType;
        this.method = method;
        method.setAccessible(true);
    }

    private Method findMethod(Class origTarget, Class target, String name, boolean allowStatic, Class<?>[] paramTypes) {
        for (Method method : target.getDeclaredMethods()) {
            if (!allowStatic && Modifier.isStatic(method.getModifiers()) || !method.getName().equals(name) || !Arrays.equals(method.getParameterTypes(), paramTypes)) continue;
            return method;
        }
        Class parent = target.getSuperclass();
        if (parent == null) {
            throw new NoSuchMethodException(String.format("Could not find method %s(%s) on %s.", name, Joiner.on(", ").join(paramTypes), origTarget.getSimpleName()));
        }
        return this.findMethod(origTarget, parent, name, allowStatic, paramTypes);
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.method.getModifiers());
    }

    public R invokeStatic(Object ... args) {
        return this.invoke(null, args);
    }

    public R invoke(T target, Object ... args) {
        try {
            Object result = this.method.invoke(target, args);
            return this.returnType.cast(result);
        }
        catch (InvocationTargetException e) {
            throw UncheckedException.throwAsUncheckedException(e.getCause());
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not call %s.%s() on %s", this.method.getDeclaringClass().getSimpleName(), this.method.getName(), target), e);
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?>[] getParameterTypes() {
        return this.method.getParameterTypes();
    }
}

