/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.buildship.ui.view.ObservableItem;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.gradle.tooling.events.FinishEvent;
import org.gradle.tooling.events.OperationDescriptor;
import org.gradle.tooling.events.StartEvent;

public final class OperationItem
extends ObservableItem
implements IAdaptable {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DURATION = "duration";
    public static final String FIELD_IMAGE = "image";
    public static final String FIELD_CHILDREN = "children";
    private final StartEvent startEvent;
    private FinishEvent finishEvent;
    private String name;
    private String duration;
    private ImageDescriptor image;
    private List<OperationItem> children;

    public OperationItem() {
        this.startEvent = null;
        this.finishEvent = null;
        this.name = null;
        this.duration = null;
        this.image = null;
        this.children = Lists.newArrayList();
    }

    public OperationItem(StartEvent startEvent) {
        this.startEvent = (StartEvent)Preconditions.checkNotNull((Object)startEvent);
        this.finishEvent = null;
        this.name = startEvent.getDescriptor().getDisplayName();
        this.duration = null;
        this.image = null;
        this.children = Lists.newArrayList();
    }

    public StartEvent getStartEvent() {
        return this.startEvent;
    }

    public FinishEvent getFinishEvent() {
        return this.finishEvent;
    }

    public void setFinishEvent(FinishEvent finishEvent) {
        this.finishEvent = finishEvent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.firePropertyChange(FIELD_NAME, this.name, this.name);
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String duration) {
        this.duration = duration;
        this.firePropertyChange(FIELD_DURATION, this.duration, this.duration);
    }

    public ImageDescriptor getImage() {
        return this.image;
    }

    public void setImage(ImageDescriptor image) {
        this.image = image;
        this.firePropertyChange(FIELD_IMAGE, this.image, this.image);
    }

    public List<OperationItem> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public void addChild(OperationItem operationItem) {
        if (!this.children.contains(operationItem)) {
            ArrayList children = Lists.newArrayList(this.children);
            children.add(operationItem);
            this.setChildren(children);
        }
    }

    public void removeChild(OperationItem operationItem) {
        if (this.children.contains(operationItem)) {
            ArrayList children = Lists.newArrayList(this.children);
            children.remove(operationItem);
            this.setChildren(children);
        }
    }

    private void setChildren(List<OperationItem> children) {
        this.children = children;
        this.firePropertyChange(FIELD_CHILDREN, this.children, this.children);
    }

    public Object getAdapter(Class adapter) {
        if (OperationDescriptor.class.equals((Object)adapter)) {
            return this.startEvent.getDescriptor();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

