/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.console;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.console.GradleConsole;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.jface.action.Action;

public final class RerunBuildExecutionAction
extends Action
implements ILaunchConfigurationListener {
    private final GradleConsole gradleConsole;

    public RerunBuildExecutionAction(GradleConsole gradleConsole) {
        this.gradleConsole = (GradleConsole)((Object)Preconditions.checkNotNull((Object)((Object)gradleConsole)));
        this.setToolTipText(UiMessages.Action_RerunBuild_Tooltip);
        this.setImageDescriptor(PluginImages.RERUN_BUILD.withState(PluginImage.ImageState.ENABLED).getImageDescriptor());
        this.setDisabledImageDescriptor(PluginImages.RERUN_BUILD.withState(PluginImage.ImageState.DISABLED).getImageDescriptor());
        this.registerJobChangeListener();
        this.registerLaunchConfigurationListener();
    }

    private void registerJobChangeListener() {
        Optional<ProcessDescription> processDescription = this.gradleConsole.getProcessDescription();
        if (processDescription.isPresent()) {
            Job job = ((ProcessDescription)processDescription.get()).getJob();
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    RerunBuildExecutionAction.this.update();
                }
            });
        }
        this.update();
    }

    private void registerLaunchConfigurationListener() {
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void run() {
        ((ProcessDescription)this.gradleConsole.getProcessDescription().get()).rerun();
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        this.update();
    }

    private void update() {
        Optional<ProcessDescription> processDescription = this.gradleConsole.getProcessDescription();
        this.setEnabled(processDescription.isPresent() && ((ProcessDescription)processDescription.get()).getJob().getState() == 0 && ((ProcessDescription)processDescription.get()).isRerunnable());
    }

    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }
}

