/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.perfo.design.service.perfoListener;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.vp.perfo.perfo.PerformanceCriteria;
import org.polarsys.capella.vp.perfo.services.PerformanceServices;

public class PerfoChangePreCommitListener
implements ResourceSetListener {
    PerformanceServices performanceServices = new PerformanceServices();

    public NotificationFilter getFilter() {
        return new NotificationFilter.Custom(){

            public boolean matches(Notification notification) {
                int eventType = notification.getEventType();
                Object notifier = notification.getNotifier();
                if (!(notification.isTouch() || eventType != 4 && eventType != 3 && eventType != 5 && eventType != 6)) {
                    Object feature = notification.getFeature();
                    if (feature instanceof EReference) {
                        return ((EReference)feature).isContainment();
                    }
                } else if (!notification.isTouch() && eventType == 1 && notifier instanceof PerformanceCriteria) {
                    return true;
                }
                return false;
            }
        };
    }

    public Command transactionAboutToCommit(ResourceSetChangeEvent event) throws RollbackException {
        TransactionalEditingDomain domain = event.getEditingDomain();
        ArrayList<RecordingCommand> commands = new ArrayList<RecordingCommand>();
        for (final Notification next : event.getNotifications()) {
            final EObject notifier = (EObject)next.getNotifier();
            switch (next.getEventType()) {
                case 1: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            if (notifier.eContainer() instanceof FunctionalChain) {
                                PerfoChangePreCommitListener.this.performanceServices.checkPerformance(notifier, notifier.eContainer());
                            } else if (notifier.eContainer() instanceof AbstractFunction) {
                                PerfoChangePreCommitListener.this.refreshFunctionalChainsPerfo((AbstractFunction)notifier.eContainer());
                            } else if (notifier.eContainer() instanceof FunctionalExchange) {
                                PerfoChangePreCommitListener.this.refreshFunctionalChainsPerfo((FunctionalExchange)notifier.eContainer());
                            }
                        }
                    });
                    break;
                }
                case 3: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            if (notifier instanceof FunctionalChain) {
                                if (next.getNewValue() instanceof PerformanceCriteria) {
                                    PerfoChangePreCommitListener.this.performanceServices.checkPerformance((EObject)next.getNewValue(), notifier);
                                } else if (next.getNewValue() instanceof FunctionalChainInvolvement) {
                                    notifier.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> PerfoChangePreCommitListener.this.performanceServices.checkPerformance(perfoObject, notifier));
                                }
                            }
                        }
                    });
                    break;
                }
                case 5: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            if (notifier instanceof FunctionalChain) {
                                notifier.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> PerfoChangePreCommitListener.this.performanceServices.checkPerformance(perfoObject, notifier));
                            }
                        }
                    });
                    break;
                }
                case 4: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            if (next.getOldValue() instanceof PerformanceCriteria) {
                                if (notifier instanceof AbstractFunction) {
                                    PerfoChangePreCommitListener.this.refreshFunctionalChainsPerfo((AbstractFunction)notifier);
                                } else if (notifier instanceof FunctionalExchange) {
                                    PerfoChangePreCommitListener.this.refreshFunctionalChainsPerfo((FunctionalExchange)notifier);
                                }
                            } else if (notifier instanceof FunctionalChain && next.getOldValue() instanceof FunctionalChainInvolvement) {
                                notifier.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> PerfoChangePreCommitListener.this.performanceServices.checkPerformance(perfoObject, notifier));
                            } else if (next.getOldValue() instanceof AbstractFunction || next.getOldValue() instanceof FunctionalExchange || next.getOldValue() instanceof PhysicalComponent) {
                                List functionalChains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)PerfoChangePreCommitListener.this.retrievePhysicalArchitectureFromEObject(notifier));
                                functionalChains.stream().forEach(functionalChain -> functionalChain.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> PerfoChangePreCommitListener.this.performanceServices.checkPerformance(perfoObject, (EObject)functionalChain)));
                            }
                        }
                    });
                    break;
                }
                case 6: {
                    commands.add(new RecordingCommand(domain){

                        protected void doExecute() {
                            if (notifier instanceof FunctionalChain) {
                                notifier.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> PerfoChangePreCommitListener.this.performanceServices.checkPerformance(perfoObject, notifier));
                            } else if (notifier instanceof AbstractFunction) {
                                PerfoChangePreCommitListener.this.refreshFunctionalChainsPerfo((AbstractFunction)notifier);
                            } else if (notifier instanceof FunctionalExchange) {
                                PerfoChangePreCommitListener.this.refreshFunctionalChainsPerfo((FunctionalExchange)notifier);
                            } else {
                                List functionalChains = FunctionalChainExt.getAllFunctionalChains((BlockArchitecture)PerfoChangePreCommitListener.this.retrievePhysicalArchitectureFromEObject(notifier));
                                functionalChains.stream().forEach(functionalChain -> functionalChain.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> PerfoChangePreCommitListener.this.performanceServices.checkPerformance(perfoObject, (EObject)functionalChain)));
                            }
                        }
                    });
                    break;
                }
            }
        }
        return commands.isEmpty() ? null : new CompoundCommand(commands);
    }

    public boolean isPrecommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
    }

    public boolean isAggregatePrecommitListener() {
        return false;
    }

    public boolean isPostcommitOnly() {
        return false;
    }

    private void refreshFunctionalChainsPerfo(AbstractFunction abstractFunction) {
        EList functionalChains = abstractFunction.getInvolvingFunctionalChains();
        functionalChains.stream().forEach(functionalChain -> functionalChain.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> this.performanceServices.checkPerformance(perfoObject, (EObject)functionalChain)));
    }

    private void refreshFunctionalChainsPerfo(FunctionalExchange functionalExchange) {
        EList functionalChains = functionalExchange.getInvolvingFunctionalChains();
        functionalChains.stream().forEach(functionalChain -> functionalChain.eContents().stream().filter(content -> content instanceof PerformanceCriteria).forEach(perfoObject -> this.performanceServices.checkPerformance(perfoObject, (EObject)functionalChain)));
    }

    private PhysicalArchitecture retrievePhysicalArchitectureFromEObject(EObject eobject) {
        ArrayList physicalAchitecture = new ArrayList();
        eobject.eResource().getContents().stream().filter(Project.class::isInstance).forEach(content -> ((Project)content).getOwnedModelRoots().stream().filter(SystemEngineering.class::isInstance).forEach(modelRoot -> ((SystemEngineering)modelRoot).getOwnedArchitectures().stream().filter(PhysicalArchitecture.class::isInstance).forEach(physicalArchitecture -> physicalAchitecture.add((PhysicalArchitecture)physicalArchitecture))));
        return (PhysicalArchitecture)physicalAchitecture.get(0);
    }
}

