/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.plantuml;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class DisplayInternalLinksHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (DisplayInternalLinksHandler.areInternalLinksShown()) {
            DisplayInternalLinksHandler.showInternalLinks(false);
        } else {
            DisplayInternalLinksHandler.showInternalLinks(true);
        }
        return null;
    }

    public static boolean areInternalLinksShown() {
        Preferences internalLinks = DisplayInternalLinksHandler.getPreference();
        return internalLinks.get("option", "turnedOff").equals("shown");
    }

    private static Preferences getPreference() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.capra.ui.plantuml.toggleInternalLinks");
        Preferences transitivity = preferences.node("internalLinks");
        return transitivity;
    }

    public static void showInternalLinks(boolean value) {
        Preferences internalLinks = DisplayInternalLinksHandler.getPreference();
        internalLinks.put("option", value ? "shown" : "turnedOff");
        try {
            internalLinks.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
    }
}

