/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.resolved;

import com.google.common.collect.Lists;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.cbi.targetplatform.model.Option;
import org.eclipse.cbi.targetplatform.resolved.UnresolvedIU;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;

public class ResolvedLocation {
    private final String id;
    private final URI uri;
    private final List<UnresolvedIU> unresolvedIUs;
    private final List<IInstallableUnit> resolvedIUs;
    private final EnumSet<Option> options;

    public ResolvedLocation(String id, String uri, List<UnresolvedIU> unresolvedIUs, EnumSet<Option> options) throws URISyntaxException {
        this(id, new URI(uri), unresolvedIUs, options);
    }

    public ResolvedLocation(String id, URI uri, List<UnresolvedIU> unresolvedIUs, EnumSet<Option> options) {
        this.id = id;
        this.uri = uri;
        this.unresolvedIUs = unresolvedIUs;
        this.resolvedIUs = Lists.newArrayList();
        this.options = options;
    }

    public Diagnostic resolve(IMetadataRepositoryManager metadataRepositoryManager, IProgressMonitor monitor) {
        BasicDiagnostic diag = new BasicDiagnostic();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        try {
            IMetadataRepository metadataRepository = metadataRepositoryManager.loadRepository(this.uri, (IProgressMonitor)subMonitor.newChild(80));
            SubMonitor loopMonitor = subMonitor.newChild(20).setWorkRemaining(this.unresolvedIUs.size());
            for (UnresolvedIU iu : this.unresolvedIUs) {
                if (!monitor.isCanceled()) {
                    Set results = metadataRepository.query(iu.getQuery(), (IProgressMonitor)loopMonitor.newChild(1)).toUnmodifiableSet();
                    if (!results.isEmpty()) {
                        IInstallableUnit unit = (IInstallableUnit)results.iterator().next();
                        if (iu.isLazyRange() && unit instanceof InstallableUnit) {
                            ((InstallableUnit)unit).setVersion(Version.create((String)"0.0.0"));
                        }
                        this.resolvedIUs.add(unit);
                        continue;
                    }
                    String msg = "Error occurred during resolution of '" + this.uri.toString() + "'. The IU '" + iu.getID() + "' with range constraint '" + iu.getVersionRange() + "' cannot be found.";
                    diag.merge((Diagnostic)new BasicDiagnostic(4, "org.eclipse.cbi.targetplatform", -1, msg, new Object[]{this, iu}));
                    continue;
                }
                break;
            }
        }
        catch (ProvisionException e) {
            diag.merge(BasicDiagnostic.toDiagnostic((Throwable)e));
        }
        return diag;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getID() {
        return this.id;
    }

    public List<UnresolvedIU> getUnresolvedIUs() {
        return this.unresolvedIUs;
    }

    public List<IInstallableUnit> getResolvedIUs() {
        return this.resolvedIUs;
    }

    public EnumSet<Option> getOptions() {
        return this.options;
    }
}

