/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cbi.targetplatform.conversion;

import com.google.inject.Singleton;
import org.eclipse.cbi.targetplatform.conversion.FQNConverter;
import org.eclipse.cbi.targetplatform.conversion.TargetPlatformSTRINGValueConverter;
import org.eclipse.cbi.targetplatform.conversion.VersionRangeConverter;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.common.services.DefaultTerminalConverters;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.lib.Exceptions;

@Singleton
public class TargetPlatformConverter
extends DefaultTerminalConverters {
    private final IValueConverter<String> versionRangeValueConverter = new VersionRangeConverter();
    private final IValueConverter<String> stringValueConverter = new TargetPlatformSTRINGValueConverter();
    private IValueConverter<String> qualifiedNameValueConverter;

    @ValueConverter(rule="VersionRange")
    public IValueConverter<String> getVersionRangeConverter() {
        return this.versionRangeValueConverter;
    }

    @ValueConverter(rule="STRING")
    public IValueConverter<String> getStringValueConverter() {
        return this.stringValueConverter;
    }

    public static String parseVersionRange(String string, INode node) {
        boolean _not;
        boolean _isEmpty = Strings.isEmpty((String)string);
        if (_isEmpty) {
            throw new ValueConverterException("Couldn't convert empty string to a VersionRange value.", node, null);
        }
        boolean _equalsIgnoreCase = "lazy".equalsIgnoreCase(string);
        boolean bl = _not = !_equalsIgnoreCase;
        if (_not) {
            try {
                VersionRange value = new VersionRange(string);
                return value.toString();
            }
            catch (Throwable _t) {
                if (_t instanceof IllegalArgumentException) {
                    IllegalArgumentException e = (IllegalArgumentException)_t;
                    throw new ValueConverterException("Couldn't convert '" + string + "' to a VersionRange value.", node, (Exception)e);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        return string;
    }

    @ValueConverter(rule="QualifiedName")
    public IValueConverter<String> getQualifiedNameConverter() {
        if (this.qualifiedNameValueConverter == null) {
            Grammar _grammar = this.getGrammar();
            FQNConverter _fQNConverter = new FQNConverter(_grammar);
            this.qualifiedNameValueConverter = _fQNConverter;
        }
        return this.qualifiedNameValueConverter;
    }
}

