/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.domain.CloudDomain;
import org.cloudfoundry.client.lib.domain.CloudRoute;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.client.CloudFoundryServerBehaviour;
import org.eclipse.cft.server.ui.internal.CFUiUtil;
import org.eclipse.cft.server.ui.internal.CloudFoundryImages;
import org.eclipse.cft.server.ui.internal.CloudRoutePart;
import org.eclipse.cft.server.ui.internal.ICoreRunnable;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.PartChangeEvent;
import org.eclipse.cft.server.ui.internal.wizards.PartsWizardPage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class CloudRoutesWizard
extends Wizard {
    private final CloudFoundryServer cloudServer;
    private CloudRoutesPage routePage;

    public CloudRoutesWizard(CloudFoundryServer server) {
        this.cloudServer = server;
        this.setWindowTitle(server.getServer().getName());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.routePage = new CloudRoutesPage(this.cloudServer);
        this.routePage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.routePage);
    }

    public boolean performFinish() {
        final List<CloudRoute> toDelete = this.routePage.getRoutesToDelete();
        if (!toDelete.isEmpty()) {
            CFUiUtil.runForked(new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    CloudRoutesWizard.this.cloudServer.getBehaviour().deleteRoute(toDelete, monitor);
                }
            }, (IWizard)this);
        }
        return true;
    }

    static class CloudRoutesPage
    extends PartsWizardPage {
        private CloudRoutePart routePart;
        private final CloudFoundryServer server;

        public CloudRoutesPage(CloudFoundryServer server) {
            super(Messages.CloudRoutesWizard_TEXT_CLOUD_ROUTE_PAGE, Messages.CloudRoutesWizard_TEXT_CLOUD_ROUTES, CloudFoundryImages.getWizardBanner(server.getServer().getServerType().getId()));
            this.setDescription(Messages.ROUTE_PAGE_DESCRIPTION);
            this.server = server;
        }

        public List<CloudRoute> getRoutesToDelete() {
            return this.routePart.getRoutesToDelete();
        }

        @Override
        public boolean isPageComplete() {
            return super.isPageComplete() && this.getRoutesToDelete() != null && !this.getRoutesToDelete().isEmpty();
        }

        @Override
        protected void performWhenPageVisible() {
            this.updateRoutes();
        }

        protected void updateRoutes() {
            this.runAsynchWithWizardProgress(new ICoreRunnable(){

                @Override
                public void run(IProgressMonitor monitor) throws CoreException {
                    CloudFoundryServerBehaviour behaviour = server.getBehaviour();
                    List domains = behaviour.getDomainsForSpace(monitor);
                    final ArrayList allRoutes = new ArrayList();
                    if (domains != null) {
                        for (CloudDomain domain : domains) {
                            List routes = behaviour.getRoutes(domain.getName(), monitor);
                            if (routes == null) continue;
                            allRoutes.addAll(routes);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    routePart.setInput(allRoutes);
                                }
                            });
                        }
                    }
                }
            }, Messages.REFRESHING_DOMAIN_ROUTES);
        }

        public void createControl(Composite parent) {
            this.routePart = new CloudRoutePart();
            this.routePart.addPartChangeListener(this);
            Control control = this.routePart.createPart(parent);
            this.setControl(control);
        }

        @Override
        public void handleChange(PartChangeEvent event) {
            Object data;
            if (event.getSource() == CloudRoutePart.ROUTES_REMOVED && (data = event.getData()) instanceof List) {
                List routes = (List)data;
                IStatus errorInUse = null;
                for (Object obj : routes) {
                    CloudRoute rt;
                    if (!(obj instanceof CloudRoute) || !(rt = (CloudRoute)obj).inUse()) continue;
                    errorInUse = CloudFoundryPlugin.getStatus((String)NLS.bind((String)Messages.ERROR_ROUTE_IN_USE, (Object)rt.getName()), (int)4);
                }
                if (errorInUse != null) {
                    event = new PartChangeEvent(event.getData(), errorInUse, event.getSource());
                }
            }
            super.handleChange(event);
        }
    }
}

