/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.verify.ui.internal;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.cft.server.verify.ui";
    private static Activator plugin;
    public static final String PREF_IS_CHECK_JAVA_VERSION = "org.eclipse.cft.server.verify.ui.check.java.version";
    public static final String PREF_LAST_PLUGIN_JAVA_VERSION_CHECK = "org.eclipse.cft.server.verify.ui.last.plugin.java.version.check";

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public synchronized boolean getIsCheckJavaVersion() {
        return this.getPreferences().getBoolean(PREF_IS_CHECK_JAVA_VERSION, true);
    }

    public synchronized String getLastPluginJavaVersionCheck() {
        return this.getPreferences().get(PREF_LAST_PLUGIN_JAVA_VERSION_CHECK, "");
    }

    public IEclipsePreferences getPreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    public synchronized void setIsCheckJavaVersion(boolean isCheckJavaVersion) {
        IEclipsePreferences prefs = this.getPreferences();
        prefs.putBoolean(PREF_IS_CHECK_JAVA_VERSION, isCheckJavaVersion);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError(e);
        }
    }

    public synchronized void setLastPluginJavaVersionCheck(String lastPluginVersion) {
        IEclipsePreferences prefs = this.getPreferences();
        prefs.put(PREF_LAST_PLUGIN_JAVA_VERSION_CHECK, lastPluginVersion);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            Activator.logError(e);
        }
    }

    public static void logError(Throwable t) {
        Activator.log(Activator.getErrorStatus(t));
    }

    public static IStatus getErrorStatus(Throwable t) {
        return new Status(4, PLUGIN_ID, t.getMessage(), t);
    }

    public static void log(IStatus status) {
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }
}

